/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clas.nb;

import java.sql.SQLException;
import java.util.HashMap;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlDefaultMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.AttributeBiCoefficient;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetProbabilitiesQuery
extends SqlBaseModelQuery<AttributeBiCoefficient, OraclePreparedStatement> {
    private int fetchSize;
    private Object targetValue;
    private boolean isNumericTarget;
    private ISqlQuery<OraclePreparedStatement> query;
    private static final String BASE_QUERY = "SELECT attribute_name_subname AS ATTRIBUTE_NAME , \n       attribute_value,\n       probability AS COEFFICIENT1  \nFROM (\n  SELECT * FROM (\n    SELECT * \n    FROM (\n      {$QUERY})\n  )\n  ORDER BY probability DESC NULLS LAST , attribute_name_subname ASC , attribute_value ASC \n)\nWHERE rownum <= {$FETCH_SIZE}";

    public GetProbabilitiesQuery(Version version, ModelDescriptor modelDescriptor, Object object, int n) {
        super(version, new SqlDefaultMapper<AttributeBiCoefficient>(AttributeBiCoefficient.class), modelDescriptor);
        this.fetchSize = n;
        this.targetValue = object;
        this.isNumericTarget = object instanceof Number;
        this.query = DbVersionHelper.isDB122Up(version) ? new DB122Query() : new OriginalQuery();
    }

    @Override
    public String getSQLCommand() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("QUERY", this.query.getSQLCommand());
        hashMap.put("FETCH_SIZE", Integer.toString(this.fetchSize));
        String string = StringUtils.getReplacedString(BASE_QUERY, hashMap);
        return string;
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        this.query.setParameters(oraclePreparedStatement);
    }

    private class DB122Query
    implements ISqlQuery<OraclePreparedStatement> {
        private DB122Query() {
        }

        @Override
        public String getSQLCommand() {
            SqlBuilder sqlBuilder = new SqlBuilder().select("CASE WHEN attribute_subname IS NOT NULL THEN\n\t  attribute_name || '.' ||  attribute_subname\n\t ELSE \n    attribute_name\nEND attribute_name_subname", "ATTRIBUTE_VALUE", "CONDITIONAL_PROBABILITY AS PROBABILITY").from(GetProbabilitiesQuery.this.getViewName("DM$VV")).where(Conditional.equals("TARGET_VALUE", GetProbabilitiesQuery.this.targetValue), Conditional.equals("PARTITION_NAME", GetProbabilitiesQuery.this.getPartitionId()));
            SqlBuilder sqlBuilder2 = new SqlBuilder().select("'<PRIOR>' ATTRIBUTE_NAME_SUBNAME", "'NULL'    ATTRIBUTE_VALUE", "PRIOR_PROBABILITY AS PROBABILITY").from(GetProbabilitiesQuery.this.getViewName("DM$VP")).where(Conditional.equals("TARGET_VALUE", GetProbabilitiesQuery.this.targetValue), Conditional.equals("PARTITION_NAME", GetProbabilitiesQuery.this.getPartitionId()));
            String string = sqlBuilder.toString() + " UNION ALL\n" + sqlBuilder2.toString();
            return string;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringAtName(oraclePreparedStatement, "PARTITION_NAME", GetProbabilitiesQuery.this.getPartitionId());
            if (GetProbabilitiesQuery.this.isNumericTarget) {
                SqlUtils.setDoubleAtName(oraclePreparedStatement, "TARGET_VALUE", ((Number)GetProbabilitiesQuery.this.targetValue).doubleValue());
            } else {
                SqlUtils.setStringAtName(oraclePreparedStatement, "TARGET_VALUE", GetProbabilitiesQuery.this.targetValue.toString());
            }
        }
    }

    private class OriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        private static final String QUERY = "SELECT CASE WHEN C.attribute_subname IS NOT NULL THEN\n                 C.attribute_name || '.' ||  C.attribute_subname\n               ELSE \n                 C.attribute_name\n             END attribute_name_subname,\n             NVL(C.attribute_str_value, C.attribute_num_value) attribute_value ,\n             C.conditional_probability probability\n      FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_NB(:model)) T,\n      TABLE(T.conditionals) C\n      WHERE T.target_attribute_num_value = :target_value \n        UNION\n      SELECT '<PRIOR>' attribute_name_subname,\n             'NULL'    attribute_value,\n             prior_probability probability\n      FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_NB(:model))\n      WHERE {$TARGET_ATTR} = :target_value";

        private OriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            String string = GetProbabilitiesQuery.this.isNumericTarget ? "target_attribute_num_value" : "target_attribute_str_value";
            String string2 = StringUtils.getReplacedString(QUERY, string);
            return string2;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            oraclePreparedStatement.setStringAtName("model", GetProbabilitiesQuery.this.getQualifiedName());
            if (GetProbabilitiesQuery.this.isNumericTarget) {
                oraclePreparedStatement.setDoubleAtName("target_value", ((Number)GetProbabilitiesQuery.this.targetValue).doubleValue());
            } else {
                oraclePreparedStatement.setStringAtName("target_value", GetProbabilitiesQuery.this.targetValue.toString());
            }
        }
    }
}

