/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clas.common;

import java.sql.SQLException;
import oracle.dmt.dataminer.core.dal.sql.SqlQuery;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlIntegerMapper;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class CostMatrixExistsQuery
extends SqlQuery<Integer, OraclePreparedStatement> {
    boolean _isPartitioned;
    String _schema;
    String _modelName;
    String _qualifiedName;

    public CostMatrixExistsQuery(Version version, boolean bl, String string, String string2) {
        super(version, new SqlIntegerMapper());
        this._qualifiedName = StringUtils.getQualifiedName(string, string2, false);
        this._isPartitioned = bl;
    }

    @Override
    public String getSQLCommand() {
        if (this._isPartitioned) {
            return "select COUNT(*) from TABLE(DBMS_DATA_MINING.GET_MODEL_COST_MATRIX(  model_name => :QUALIFIED_MODEL_NAME,   partition_name => (select PARTITION_NAME from ALL_MINING_MODEL_PARTITIONS WHERE OWNER= :OWNER AND MODEL_NAME= :MODEL_NAME AND ROWNUM = 1) ))";
        }
        return "select COUNT(*) from TABLE(DBMS_DATA_MINING.GET_MODEL_COST_MATRIX(model_name => :QUALIFIED_MODEL_NAME))";
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        if (this._isPartitioned) {
            oraclePreparedStatement.setStringAtName("QUALIFIED_MODEL_NAME", this._qualifiedName);
            oraclePreparedStatement.setStringAtName("OWNER", this._schema);
            oraclePreparedStatement.setStringAtName("MODEL_NAME", this._modelName);
        } else {
            oraclePreparedStatement.setStringAtName("QUALIFIED_MODEL_NAME", this._qualifiedName);
        }
    }
}

