/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.ar.ap;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import oracle.dmt.dataminer.core.dal.sql.mapping.ar.ap.GetFilterItemSetsMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.model.ar.FilterItemSet;
import oracle.dmt.dataminer.core.model.ar.ItemSetFilterSetting;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.filter.SortSpec;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetFilerItemSetsQuery
extends SqlBaseModelQuery<FilterItemSet, OraclePreparedStatement> {
    private ItemSetFilterSetting setting;
    private boolean useNameFilter;

    public GetFilerItemSetsQuery(Version version, ModelDescriptor modelDescriptor, ItemSetFilterSetting itemSetFilterSetting) {
        super(version, new GetFilterItemSetsMapper(itemSetFilterSetting), modelDescriptor);
        this.setting = itemSetFilterSetting;
    }

    @Override
    public String getSQLCommand() {
        String string = "";
        List<SortSpec> list = this.setting.getSortSpecification();
        boolean bl = false;
        switch (this.setting.getResultType()) {
            case 1: {
                string = this.isPartitioned() ? "With base_query as (<BASE_SELECT_CLAUSE> FROM TABLE(dbms_data_mining.get_frequent_itemsets(?,   ?,   ?, ?)) t, TABLE(t.items) item), final_query as (Select SUBSTR(full_name,1,REGEXP_INSTR(full_name,'[\"]+',1, 1)-1) attribute_name, SUBSTR(full_name, REGEXP_INSTR(full_name,'[\"]+',1, 1)+1) attribute_subname, NULL support, NULL attribute_value FROM (Select distinct(full_name)full_name       FROM base_query) a <WHERE_CLAUSE> <ORDER_BY_CLAUSE> ) Select * from final_query where rownum <= ? " : "With base_query as (<BASE_SELECT_CLAUSE> FROM TABLE(dbms_data_mining.get_frequent_itemsets(?,   ?,   ?)) t, TABLE(t.items) item), final_query as (Select SUBSTR(full_name,1,REGEXP_INSTR(full_name,'[\"]+',1, 1)-1) attribute_name, SUBSTR(full_name, REGEXP_INSTR(full_name,'[\"]+',1, 1)+1) attribute_subname, NULL support, NULL attribute_value FROM (Select distinct(full_name)full_name       FROM base_query) a <WHERE_CLAUSE> <ORDER_BY_CLAUSE> ) Select * from final_query where rownum <= ? ";
                string = StringUtils.getReplacedString(string, "<BASE_SELECT_CLAUSE>", "SELECT CONCAT(item.attribute_name,'\"') full_name ");
                break;
            }
            case 2: {
                string = this.isPartitioned() ? "With base_query as (<BASE_SELECT_CLAUSE> FROM TABLE(dbms_data_mining.get_frequent_itemsets(?,   ?,   ?, ?)) t, TABLE(t.items) item), final_query as (Select SUBSTR(full_name,1,REGEXP_INSTR(full_name,'[\"]+',1, 1)-1) attribute_name, SUBSTR(full_name, REGEXP_INSTR(full_name,'[\"]+',1, 1)+1) attribute_subname, NULL support, NULL attribute_value FROM (Select distinct(full_name)full_name       FROM base_query) a <WHERE_CLAUSE> <ORDER_BY_CLAUSE> ) Select * from final_query where rownum <= ? " : "With base_query as (<BASE_SELECT_CLAUSE> FROM TABLE(dbms_data_mining.get_frequent_itemsets(?,   ?,   ?)) t, TABLE(t.items) item), final_query as (Select SUBSTR(full_name,1,REGEXP_INSTR(full_name,'[\"]+',1, 1)-1) attribute_name, SUBSTR(full_name, REGEXP_INSTR(full_name,'[\"]+',1, 1)+1) attribute_subname, NULL support, NULL attribute_value FROM (Select distinct(full_name)full_name       FROM base_query) a <WHERE_CLAUSE> <ORDER_BY_CLAUSE> ) Select * from final_query where rownum <= ? ";
                string = StringUtils.getReplacedString(string, "<BASE_SELECT_CLAUSE>", "SELECT NVL2(item.attribute_subname, item.attribute_name || '\"' || item.attribute_subname, CONCAT(item.attribute_name,'\"')) full_name ");
                break;
            }
            case 3: {
                string = this.isPartitioned() ? "With base_query as (<BASE_SELECT_CLAUSE> FROM TABLE(dbms_data_mining.get_frequent_itemsets(?,   ?,   ?, ?)) t, TABLE(t.items) item), final_query as (Select SUBSTR(full_name,1,REGEXP_INSTR(full_name,'[\"]+',1, 1)-1) attribute_name, SUBSTR(full_name, REGEXP_INSTR(full_name,'[\"]+',1, 1)+1) attribute_subname, attribute_num_value, attribute_str_value, support, NVL2( attribute_num_value, TO_CHAR(attribute_num_value), attribute_str_value) attribute_value  FROM base_query <WHERE_CLAUSE> <ORDER_BY_CLAUSE> ) Select * from final_query where rownum <= ? " : "With base_query as (<BASE_SELECT_CLAUSE> FROM TABLE(dbms_data_mining.get_frequent_itemsets(?,   ?,   ?)) t, TABLE(t.items) item), final_query as (Select SUBSTR(full_name,1,REGEXP_INSTR(full_name,'[\"]+',1, 1)-1) attribute_name, SUBSTR(full_name, REGEXP_INSTR(full_name,'[\"]+',1, 1)+1) attribute_subname, attribute_num_value, attribute_str_value, support, NVL2( attribute_num_value, TO_CHAR(attribute_num_value), attribute_str_value) attribute_value  FROM base_query <WHERE_CLAUSE> <ORDER_BY_CLAUSE> ) Select * from final_query where rownum <= ? ";
                string = StringUtils.getReplacedString(string, "<BASE_SELECT_CLAUSE>", "SELECT NVL2(item.attribute_subname, item.attribute_name || '\"' || item.attribute_subname, CONCAT(item.attribute_name,'\"')) full_name, item.attribute_num_value attribute_num_value, item.attribute_str_value attribute_str_value, support ");
                break;
            }
            default: {
                assert (false) : "Invalid query result type request for itemsets.";
                break;
            }
        }
        Object object = "";
        if (this.setting.getNameFilter() != null && this.setting.getNameFilter().length() > 0) {
            object = (String)object + " WHERE REPLACE(full_name,'\"','.') like (?)";
            bl = true;
        }
        string = StringUtils.getReplacedString(string, "<WHERE_CLAUSE>", (String)object);
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null && list.size() > 0) {
            stringBuilder.append("order by ");
            Iterator<SortSpec> iterator = list.iterator();
            while (iterator.hasNext()) {
                SortSpec sortSpec = iterator.next();
                if (!sortSpec.isUseIt()) continue;
                stringBuilder.append("\"" + sortSpec.getAttributeName() + "\" ");
                if (sortSpec.isAscending()) {
                    stringBuilder.append("ASC ");
                } else {
                    stringBuilder.append("DESC NULLS LAST ");
                }
                if (!iterator.hasNext()) continue;
                stringBuilder.append(",");
            }
            if (stringBuilder.substring(stringBuilder.length() - 1, stringBuilder.length()).equalsIgnoreCase(",")) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
        }
        string = StringUtils.getReplacedString(string, "<ORDER_BY_CLAUSE>", stringBuilder.toString());
        return string;
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        oraclePreparedStatement.setString(1, this.getQualifiedName());
        if (this.setting.isUseTopN()) {
            oraclePreparedStatement.setInt(2, this.setting.getTopNBySupport().intValue());
        } else {
            oraclePreparedStatement.setNull(2, 4);
        }
        if (this.setting.isUseNumberOfItems()) {
            oraclePreparedStatement.setInt(3, this.setting.getNumberOfItems().intValue());
        } else {
            oraclePreparedStatement.setNull(3, 4);
        }
        if (this.useNameFilter) {
            oraclePreparedStatement.setString(4, "%" + this.setting.getNameFilter() + "%");
            if (this.isPartitioned()) {
                oraclePreparedStatement.setString(5, this.getPartitionId());
                oraclePreparedStatement.setInt(6, this.setting.getFetchSize());
            } else {
                oraclePreparedStatement.setInt(5, this.setting.getFetchSize());
            }
        } else if (this.isPartitioned()) {
            oraclePreparedStatement.setString(4, this.getPartitionId());
            oraclePreparedStatement.setInt(5, this.setting.getFetchSize());
        } else {
            oraclePreparedStatement.setInt(4, this.setting.getFetchSize());
        }
        oraclePreparedStatement.setFetchSize(1000);
    }
}

