/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.mapping.common.build;

import java.sql.ResultSet;
import oracle.dmt.dataminer.core.dal.sql.ISqlMapper;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.core.utils.Patterns;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;

public class GetModelDetailsGlobalMapper
extends SqlMapper<NameValuePair> {
    protected ISqlMapper<NameValuePair> mapper;

    public GetModelDetailsGlobalMapper(Version version) {
        super(version);
        this.mapper = DbVersionHelper.isDB122Up(version) ? new Db12_2Mapper() : new DbOriginalMapper();
    }

    @Override
    public NameValuePair map(ResultSet resultSet) throws Exception {
        return this.mapper.map(resultSet);
    }

    private class Db12_2Mapper
    implements ISqlMapper<NameValuePair> {
        private Db12_2Mapper() {
        }

        @Override
        public NameValuePair map(ResultSet resultSet) throws Exception {
            String string = resultSet.getString("NAME");
            String string2 = resultSet.getString("STRING_VALUE");
            Double d = resultSet.getDouble("NUMERIC_VALUE");
            Object object = string2 != null ? string2 : d;
            NameValuePair nameValuePair = new NameValuePair(string, object);
            return nameValuePair;
        }
    }

    private class DbOriginalMapper
    implements ISqlMapper<NameValuePair> {
        private DbOriginalMapper() {
        }

        @Override
        public NameValuePair map(ResultSet resultSet) throws Exception {
            String string = resultSet.getString("GLOBAL_DETAIL_NAME");
            String string2 = resultSet.getString("GLOBAL_DETAIL_VALUE");
            boolean bl = StringUtils.isNotEmpty(string2) && !Patterns.STRINGS.matcher(string2).matches();
            NameValuePair nameValuePair = new NameValuePair(string, string2);
            if (bl) {
                nameValuePair.setValue(Double.valueOf(string2));
            }
            return nameValuePair;
        }
    }
}

