/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.mapping.clas.common;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.model.clas.common.ProfitInfo;

public class GetProfitResultsMapper
extends SqlMapper<ProfitInfo> {
    private String miningAlgo;
    private Date creationTime;
    private Integer testRows;
    private Integer buildRows;

    public GetProfitResultsMapper(String string, Date date) {
        this(string, date, null, null);
    }

    public GetProfitResultsMapper(String string, Date date, Integer n, Integer n2) {
        this.miningAlgo = string;
        this.creationTime = date;
        this.buildRows = n;
        this.testRows = n2;
    }

    @Override
    public ProfitInfo map(ResultSet resultSet) throws Exception {
        double d;
        int n = resultSet.getInt("QUANTILE_NUMBER");
        try {
            d = resultSet.getDouble("PROBABILITY_THRESHOLD");
        }
        catch (SQLException sQLException) {
            d = resultSet.getDouble("COST_THRESHOLD");
        }
        double d2 = resultSet.getDouble("PERCENTAGE_RECORDS_CUMULATIVE");
        double d3 = resultSet.getDouble("TARGET_DENSITY_CUMULATIVE");
        double d4 = resultSet.getDouble("TARGETS_CUMULATIVE");
        double d5 = resultSet.getDouble("NON_TARGETS_CUMULATIVE");
        ProfitInfo profitInfo = new ProfitInfo(n, d, d2, d3, d4, d5, this.miningAlgo, this.creationTime);
        profitInfo.setBuildRows(this.buildRows);
        profitInfo.setTestRows(this.testRows);
        return profitInfo;
    }
}

