/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.util;

import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.net.FileLocator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.exports.file.KnownFile;
import oracle.jdeveloper.audit.service.AuditLogger;

public abstract class KnownFileCache<T> {
    private static final boolean LOCK_KNOWN_FILES = "true".equalsIgnoreCase(System.getProperty("audit.lock.known.files"));
    private final KnownFile resource;
    private final Class<?> referenceType;
    private final String name;
    private final String extension;
    private boolean configured;
    private SoftReference<T> cachedValue;
    private boolean overrideLocked;
    private boolean propertyOverride;
    private boolean patchesOverride;
    private URL overrideUrl;
    private boolean overrideFailed;

    protected Class<?> getReferenceType() {
        return this.referenceType;
    }

    public KnownFileCache(Class<?> referenceType, String name) {
        this(new KnownFile(referenceType, name), referenceType, name);
    }

    public KnownFileCache(KnownFile resource) {
        this(resource, resource.getReference(), resource.getName());
    }

    private KnownFileCache(KnownFile resource, Class<?> referenceType, String name) {
        this.resource = resource;
        this.referenceType = referenceType != null ? referenceType : this.getClass();
        int dot = name.lastIndexOf(46);
        if (dot < 0) {
            dot = name.length();
        }
        this.name = name.substring(0, dot);
        this.extension = name.substring(dot);
    }

    public synchronized void reset() {
        this.configured = false;
        this.cachedValue = null;
        this.overrideUrl = null;
        this.overrideFailed = false;
        this.patchesOverride = false;
        this.propertyOverride = false;
    }

    public String getName() {
        return this.name;
    }

    public boolean isOverrideLocked() {
        return LOCK_KNOWN_FILES || "true".equalsIgnoreCase("audit.lock.known.file." + this.name);
    }

    private void configure() {
        if (this.configured) {
            return;
        }
        this.configured = true;
        if (this.isOverrideLocked()) {
            this.overrideLocked = true;
        } else {
            String patchDirPath;
            File file;
            if (System.getProperty("audit." + this.name) != null && (file = new File(System.getProperty("audit." + this.name))).isFile()) {
                this.overrideUrl = URLFactory.newFileURL((File)file);
                this.propertyOverride = true;
            }
            if (this.overrideUrl == null && (patchDirPath = System.getProperty("ide.patches.dir")) != null) {
                File home = new File(Ide.getOracleHomeDirectory());
                for (String patchDirName : patchDirPath.split(",")) {
                    File file2;
                    File dir = new File(patchDirName);
                    if (!dir.isAbsolute()) {
                        dir = new File(home, patchDirName);
                    }
                    if (!(file2 = new File(dir, this.name + this.extension)).isFile()) continue;
                    this.overrideUrl = URLFactory.newFileURL((File)file2);
                    this.patchesOverride = true;
                    break;
                }
            }
        }
    }

    public synchronized boolean isOverridden() {
        return this.overrideUrl != null;
    }

    public synchronized boolean isOverrrideFailed() {
        return this.overrideFailed;
    }

    public boolean isPatchesOverride() {
        return this.patchesOverride;
    }

    public boolean isPropertyOverride() {
        return this.propertyOverride;
    }

    public synchronized T getValue() throws Exception {
        T oldValue;
        this.configure();
        if (this.cachedValue != null && (oldValue = this.cachedValue.get()) != null) {
            return oldValue;
        }
        T newValue = null;
        try {
            newValue = this.createValue(this.name + this.extension, this.overrideUrl);
        }
        catch (Exception e) {
            if (this.overrideUrl == null) {
                throw e;
            }
            this.overrideUrl = null;
            this.overrideFailed = true;
            AuditLogger.error("Override of default {0} file at {1} failed: {2}", e, this.name, this.overrideUrl, e);
            newValue = this.createValue(this.name + this.extension, null);
        }
        this.cachedValue = new SoftReference<Object>(newValue);
        return newValue;
    }

    public synchronized T getCachedValue() {
        return this.cachedValue != null ? (T)this.cachedValue.get() : null;
    }

    protected abstract T createValue(String var1, URL var2) throws Exception;

    public long getLastModifiedTime() {
        this.configure();
        return URLFileSystem.lastModified((URL)(this.overrideUrl != null ? this.overrideUrl : this.resource.getUrl()));
    }

    public String getFileName() {
        this.configure();
        return this.overrideUrl != null ? URLFileSystem.getFileName((URL)this.overrideUrl) : this.name + this.extension;
    }

    public String getDescription() {
        URL url;
        this.configure();
        StringBuilder builder = new StringBuilder("Resource ").append(this.name);
        if (this.cachedValue == null) {
            builder.append(" not initialized");
        } else if (this.propertyOverride) {
            String property = "audit." + this.name;
            builder.append(" overridden by system property ").append(property);
            builder.append(" to ").append(URLFileSystem.getPlatformPathName((URL)this.overrideUrl));
        } else if (this.patchesOverride) {
            builder.append(" overridden from patches directory to ");
            builder.append(URLFileSystem.getPlatformPathName((URL)this.overrideUrl));
        } else {
            url = this.resource.getUrl();
            try {
                url = FileLocator.resolve((URL)url);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            builder.append(" defaulted to ").append(URLFileSystem.getPlatformPathName((URL)url));
            if (this.overrideLocked) {
                builder.append(" (override locked)");
            }
        }
        if (this.overrideFailed) {
            url = this.resource.getUrl();
            try {
                url = FileLocator.resolve((URL)url);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            builder.append(": override failed, defaulted to ").append(URLFileSystem.getPlatformPathName((URL)url));
        }
        return builder.toString();
    }
}

