/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArraysIterator
implements Iterator {
    private Object[][] arrays;
    private int major = 0;
    private int minor = 0;
    private int limit;

    public ArraysIterator(Object[] a) {
        this.initialize(new Object[][]{a});
    }

    public ArraysIterator(Object[] a1, Object[] a2) {
        this.initialize(new Object[][]{a1, a2});
    }

    public ArraysIterator(Object[] a1, Object[] a2, Object[] a3) {
        this.initialize(new Object[][]{a1, a2, a3});
    }

    public ArraysIterator(Object[] a1, Object[] a2, Object[] a3, Object[] a4) {
        this.initialize(new Object[][]{a1, a2, a3, a4});
    }

    private void initialize(Object[][] arrays) {
        this.arrays = arrays;
        int delta = 0;
        for (int i = 0; i < arrays.length; ++i) {
            Object[] array = arrays[i];
            if (array != null && array.length != 0) continue;
            while (i < arrays.length) {
                array = arrays[i];
                if (array == null || array.length == 0) {
                    ++delta;
                } else {
                    arrays[i - delta] = array;
                }
                ++i;
            }
        }
        this.limit = arrays.length - delta;
    }

    @Override
    public boolean hasNext() {
        return this.major < this.limit;
    }

    public Object next() {
        if (this.major >= this.limit) {
            throw new NoSuchElementException();
        }
        Object object = this.arrays[this.major][this.minor++];
        if (this.minor >= this.arrays[this.major].length) {
            ++this.major;
            this.minor = 0;
        }
        return object;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

