/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import com.sun.java.swing.plaf.motif.MotifLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalLookAndFeel;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.javatools.util.Log;

public class FocusBorder
extends AbstractBorder
implements FocusListener {
    private static final Log LOG = new Log("focusborder");
    private Component focusComponent;
    private Component borderedComponent;
    private Insets innerMargin;
    private Insets outerMargin;
    private static final Insets ZERO = new Insets(0, 0, 0, 0);
    private static final int GTK_LAF = 0;
    private static final int METAL_LAF = 1;
    private static final int MOTIF_LAF = 2;
    private static final int ORACLE_LAF = 3;
    private static final int WINDOWS_LAF = 4;
    private LookAndFeel lastLaf = null;
    private int lastLafCode = -1;

    public FocusBorder() {
        this(null, null, null);
    }

    public FocusBorder(Component component) {
        this(null, null, component);
    }

    public FocusBorder(int innerMargin, int outerMargin) {
        this(new Insets(innerMargin, innerMargin, innerMargin, innerMargin), new Insets(outerMargin, outerMargin, outerMargin, outerMargin), null);
    }

    public FocusBorder(Insets innerMargin, Insets outerMargin) {
        this(innerMargin, outerMargin, null);
    }

    public FocusBorder(int innerMargin, int outerMargin, Component component) {
        this(new Insets(innerMargin, innerMargin, innerMargin, innerMargin), new Insets(outerMargin, outerMargin, outerMargin, outerMargin), component);
    }

    public FocusBorder(Insets innerMargin, Insets outerMargin, Component component) {
        if (innerMargin == null) {
            innerMargin = ZERO;
        }
        this.innerMargin = new Insets(innerMargin.top, innerMargin.left, innerMargin.bottom, innerMargin.right);
        if (outerMargin == null) {
            outerMargin = ZERO;
        }
        this.outerMargin = new Insets(outerMargin.top, outerMargin.left, outerMargin.bottom, outerMargin.right);
        this.focusComponent = component;
        if (component != null) {
            component.addFocusListener(this);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = this.innerMargin.top + this.outerMargin.top + 1;
        insets.left = this.innerMargin.left + this.outerMargin.left + 1;
        insets.bottom = this.innerMargin.bottom + this.outerMargin.bottom + 1;
        insets.right = this.innerMargin.right + this.outerMargin.right + 1;
        return insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        LOG.trace("painting border of component {2}, graphics {3}, x {0}, y {1}", x, y, (Object)c, (Object)g);
        LOG.trace("width {0}, height {1}, margin {2}", width, height, (Object)this.outerMargin);
        if (this.borderedComponent == null) {
            this.borderedComponent = c;
        }
        if (this.focusComponent == null) {
            this.focusComponent = c;
            this.focusComponent.addFocusListener(this);
        }
        Color oldColor = g.getColor();
        if (this.focusComponent.isFocusOwner()) {
            switch (this.lafCode()) {
                case 0: {
                    this.drawGTKFocus(c, g, x, y, width, height);
                    break;
                }
                case 1: {
                    this.drawSolidFocus(g, x, y, width, height, MetalLookAndFeel.getFocusColor());
                    break;
                }
                case 2: {
                    this.drawSolidFocus(g, x, y, width, height, UIManager.getColor("activeCaptionBorder"));
                    break;
                }
                case 3: {
                    this.drawOracleFocus(g, x, y, width, height);
                    break;
                }
                case 4: {
                    this.drawWindowsFocus(g, x, y, width, height);
                    break;
                }
                default: {
                    this.drawWindowsFocus(g, x, y, width, height);
                }
            }
        }
        g.setColor(oldColor);
    }

    private int lafCode() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf == this.lastLaf) {
            return this.lastLafCode;
        }
        this.lastLaf = laf;
        this.lastLafCode = laf.getName().indexOf("GTK") >= 0 ? 0 : (laf instanceof MetalLookAndFeel ? 1 : (laf instanceof MotifLookAndFeel ? 2 : (laf instanceof OracleLookAndFeel ? 3 : (laf instanceof WindowsLookAndFeel ? 4 : -1))));
        return this.lastLafCode;
    }

    private void drawSolidFocus(Graphics g, int x, int y, int width, int height, Color color) {
        if (color == null) {
            color = Color.BLACK;
        }
        g.setColor(color);
        g.drawRect(x + this.outerMargin.left, y + this.outerMargin.top, width - this.outerMargin.left - this.outerMargin.right - 1, height - this.outerMargin.top - this.outerMargin.bottom - 1);
    }

    private void drawWindowsFocus(Graphics g, int x, int y, int width, int height) {
        Color foreground = this.focusComponent.getForeground();
        if (foreground == null) {
            foreground = Color.BLACK;
        }
        g.setColor(foreground);
        BasicGraphicsUtils.drawDashedRect(g, x + this.outerMargin.left, y + this.outerMargin.top, width - this.outerMargin.left - this.outerMargin.right, height - this.outerMargin.top - this.outerMargin.bottom);
    }

    private void drawOracleFocus(Graphics g, int x, int y, int width, int height) {
        Color foreground = this.focusComponent.getForeground();
        if (foreground == null) {
            foreground = Color.BLACK;
        }
        g.setColor(foreground);
        x += this.outerMargin.left;
        int bottomy = (y += this.outerMargin.top) + (height -= this.outerMargin.top + this.outerMargin.bottom) - 1;
        int segments = (width -= this.outerMargin.left + this.outerMargin.right) / 3;
        while (segments-- > 0) {
            g.fillRect(x, y, 2, 1);
            g.fillRect(x, bottomy, 2, 1);
            x += 3;
        }
        int excess = width % 3;
        g.fillRect(x, y, excess, 1);
        g.fillRect(x, bottomy, excess, 1);
    }

    private void drawGTKFocus(Component c, Graphics g, int x, int y, int width, int height) {
        Color foreground = this.focusComponent.getForeground();
        if (foreground == null) {
            foreground = Color.BLACK;
        }
        g.setColor(foreground);
        Border border = UIManager.getBorder("List.focusCellHighlightBorder");
        border.paintBorder(c, g, x += this.outerMargin.left, y += this.outerMargin.top, width -= this.outerMargin.left + this.outerMargin.right, height -= this.outerMargin.top + this.outerMargin.bottom);
    }

    @Override
    public void focusGained(FocusEvent e) {
        LOG.trace("focus gained at {0} repaining {1}", (Object)e.getComponent(), (Object)this.borderedComponent);
        this.borderedComponent.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        LOG.trace("focus lost at {0} repaining {1}", (Object)e.getComponent(), (Object)this.borderedComponent);
        this.borderedComponent.repaint();
    }
}

