/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.report;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ideri.util.Product;
import oracle.javatools.util.Log;
import oracle.javatools.util.MultiMap;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdevimpl.audit.report.StyleSheet;

public class StyleSheetRepository {
    private URL directory;
    private Map<String, StyleSheet> styleSheets;
    private static final Log LOG = new Log("stylesheet");

    public List<StyleSheet> getStyleSheets() {
        this.scan();
        return new ArrayList<StyleSheet>(this.styleSheets.values());
    }

    public StyleSheet getStyleSheet(String name) {
        if (name == null) {
            return null;
        }
        this.scan();
        return this.styleSheets.get(name.toUpperCase());
    }

    private void scan() {
        if (this.directory != null) {
            return;
        }
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        URL system = registry.getSystemDirectory(Product.getProductID());
        this.directory = URLFactory.newDirURL((URL)system, (String)"audit/stylesheets");
        URLFileSystem.mkdirs((URL)this.directory);
        this.ensureDefaultStyleSheets();
        this.styleSheets = new HashMap<String, StyleSheet>();
        URL[] urls = URLFileSystem.list((URL)this.directory);
        if (urls == null) {
            return;
        }
        for (URL url : urls) {
            if (!".xsl".equals(URLFileSystem.getSuffix((URL)url))) continue;
            StyleSheet styleSheet = new StyleSheet(url);
            this.styleSheets.put(styleSheet.getName().toUpperCase(), styleSheet);
        }
        LOG.trace("scanned {0} for {1}", (Object)this.directory, this.styleSheets);
    }

    protected void ensureDefaultStyleSheets() {
        LOG.trace("ensuring default style sheets");
        MultiMap names = new MultiMap();
        for (URL url : AuditManager.getAuditManager().getStyleSheets()) {
            names.add((Object)URLFileSystem.getName((URL)url), (Object)url);
        }
        Set entries = names.entrySet();
        for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            Collection list = (Collection)entry.getValue();
            if (list.size() == 1) {
                this.ensureDefaultStyleSheet(name, (URL)list.iterator().next());
                continue;
            }
            int index = 1;
            for (URL url : list) {
                String uniqueName;
                while (!names.containsKey((Object)(uniqueName = name + " (" + index++ + ")"))) {
                }
                this.ensureDefaultStyleSheet(uniqueName, url);
            }
        }
    }

    protected void ensureDefaultStyleSheet(String name, URL url) {
        URL toURL = URLFactory.newURL((URL)this.directory, (String)(name + ".xsl"));
        try {
            URLFileSystem.copy((URL)url, (URL)toURL);
        }
        catch (IOException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
    }
}

