/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.Mutables;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.util.Log;
import oracle.javatools.util.NullArgumentException;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.IssueReport;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.SuppressionReport;
import oracle.jdeveloper.audit.analyzer.SuppressionScheme;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAccessError;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.Auditor;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.core.AnalyzerBinding;
import oracle.jdevimpl.audit.core.AuditListenerList;
import oracle.jdevimpl.audit.core.BoundMethod;
import oracle.jdevimpl.audit.core.CoreBeans;
import oracle.jdevimpl.audit.core.DefaultAuditor;
import oracle.jdevimpl.audit.core.DefaultIssue;
import oracle.jdevimpl.audit.core.IssueCollector;
import oracle.jdevimpl.audit.util.Strings;

public final class DefaultAuditContext
implements AuditContext {
    private final DefaultAuditor auditor;
    private final AuditListenerList listeners;
    private final IssueCollector issueCollector;
    private final DefaultAuditContext enclosingContext;
    private final int depth;
    private List<Analyzer> disabledAnalyzers = new ArrayList<Analyzer>();
    private final Object[] arguments = new Object[2];
    private ModelAdapter model;
    private Location location;
    private Object construct;
    private Class<?> presentationType;
    private boolean isAuditRoot;
    private Attributes attributes;
    private Map<Location, Attributes> childAttributes;
    private BoundMethod<Analyzer> invokedMethod;
    private Mutables.Integer attributeCount;
    private Map<Object, AuditContext.Key> sharedAttributes;
    private DefaultAuditContext childContext;
    private static final Object NULL_VALUE = new Object();
    private static final Log LOG = new Log("keys");
    private static final Log LOG_COUNTS = new Log("audit-context-counts");
    private static final IssueReport NULL_ISSUE_REPORT = new IssueReport(){

        @Override
        public void addParameter(String name, Object value) {
        }

        @Override
        public void addConstructParameter(String name, Object construct) {
        }

        @Override
        public void addConstructParameter(String name, ModelAdapter model, Object construct) {
        }

        @Override
        public void setFocusLocation(Object construct) {
        }

        @Override
        public void setFocusLocation(Location location) {
        }

        @Override
        public void setVariation(String name) {
        }

        @Override
        public void hideAllTransforms() {
        }

        @Override
        public void showTransform(Transform transform) {
        }

        @Override
        public void hideTransform(Transform transform) {
        }

        @Override
        public void setDefaultTransform(Transform transform) {
        }

        @Override
        public Rule getRule() {
            return null;
        }

        @Override
        public String getVariation() {
            return null;
        }

        @Override
        public Location getLocation() {
            return null;
        }

        @Override
        public Location getFocusLocation() {
            return null;
        }

        @Override
        public Object getParameterValue(String name) {
            return null;
        }

        @Override
        public void cancel() {
        }
    };
    private static final SuppressionReport NULL_SUPPRESSION_REPORT = new SuppressionReport(){

        @Override
        public void addParameter(String name, Object value) {
        }
    };

    DefaultAuditContext(DefaultAuditor auditor, AuditListenerList listeners, IssueCollector issueCollector) {
        this.auditor = auditor;
        this.listeners = listeners;
        this.issueCollector = issueCollector;
        this.enclosingContext = null;
        this.arguments[0] = this;
        this.depth = 0;
        this.attributeCount = new Mutables.Integer(0);
        this.sharedAttributes = new HashMap<Object, AuditContext.Key>();
    }

    private DefaultAuditContext(DefaultAuditContext enclosingContext) {
        this.auditor = enclosingContext.auditor;
        this.issueCollector = enclosingContext.issueCollector;
        this.listeners = enclosingContext.listeners;
        this.enclosingContext = enclosingContext;
        this.arguments[0] = this;
        this.depth = enclosingContext.depth + 1;
        this.attributeCount = enclosingContext.attributeCount;
        this.sharedAttributes = enclosingContext.sharedAttributes;
    }

    DefaultAuditContext enterContext(ModelAdapter model, Location location, Object construct, Class<?> presentationType, boolean isRoot) {
        assert (model != null);
        assert (construct != null);
        assert (location == null || model == location.getModel());
        if (this.childContext == null) {
            this.childContext = new DefaultAuditContext(this);
        }
        this.childContext.model = model;
        this.childContext.location = location;
        this.childContext.construct = construct;
        this.childContext.presentationType = presentationType;
        this.childContext.isAuditRoot = isRoot;
        this.childContext.disabledAnalyzers.clear();
        this.childContext.arguments[1] = construct;
        if (this.childAttributes != null) {
            this.childContext.attributes = this.childAttributes.get(this.childContext.getLocation());
        }
        this.issueCollector.enteringContext(this.childContext);
        return this.childContext;
    }

    void invokeModelEnterMethod() {
        this.issueCollector.enteringMethodList(this);
        try {
            this.getModel().enter(this);
        }
        catch (ExpiredTextBufferException e) {
            this.cancel();
            throw e;
        }
        catch (CancellationException e) {
            this.cancel();
            throw e;
        }
        catch (OutOfMemoryError e) {
            this.cancel();
            throw e;
        }
        catch (Throwable e) {
            this.reportTraversalException(e, this.arguments[1]);
        }
        finally {
            this.issueCollector.exitingMethod();
            this.issueCollector.exitingMethodList(this);
        }
    }

    void invokeModelExitMethod() {
        this.issueCollector.enteringMethodList(this);
        try {
            this.getModel().exit(this);
        }
        finally {
            this.issueCollector.exitingMethod();
            this.issueCollector.exitingMethodList(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int invokeEnterMethods(AnalyzerBinding.EnterExitMethods methods) {
        this.issueCollector.enteringMethodList(this);
        try {
            for (BoundMethod<Analyzer> method : methods.getEnterMethods()) {
                boolean success;
                this.throwIfCancelled();
                Analyzer analyzer = method.getTarget();
                if (!analyzer.isEnabled() || !(success = this.invoke(method, this.arguments)) || analyzer.isEnabled()) continue;
                this.disabledAnalyzers.add(analyzer);
            }
            int n = this.disabledAnalyzers.size();
            return n;
        }
        finally {
            this.issueCollector.exitingMethodList(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int invokeExitMethods(AnalyzerBinding.EnterExitMethods methods) {
        this.issueCollector.enteringMethodList(this);
        try {
            for (BoundMethod<Analyzer> method : methods.getExitMethods()) {
                this.throwIfCancelled();
                Analyzer analyzer = method.getTarget();
                if (!analyzer.isEnabled()) continue;
                this.invoke(method, this.arguments);
            }
            int n = -this.disabledAnalyzers.size();
            return n;
        }
        finally {
            for (Analyzer analyzer : this.disabledAnalyzers) {
                analyzer.setEnabled(true);
            }
            this.issueCollector.exitingMethodList(this);
        }
    }

    void invokeReviewMethods(List<BoundMethod<Analyzer>> methods, DefaultIssue issue) {
        Object[] arguments = new Object[]{this, issue};
        for (BoundMethod<Analyzer> method : methods) {
            this.throwIfCancelled();
            Analyzer analyzer = method.getTarget();
            if (!analyzer.isEnabled()) continue;
            this.invoke(method, arguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invoke(BoundMethod<Analyzer> method, Object[] arguments) {
        try {
            this.invokedMethod = method;
            method.invoke(arguments);
            this.issueCollector.exitingMethod();
            boolean bl = true;
            return bl;
        }
        catch (ExpiredTextBufferException e) {
            this.cancel();
            throw e;
        }
        catch (CancellationException e) {
            this.cancel();
            throw e;
        }
        catch (OutOfMemoryError e) {
            this.cancel();
            throw e;
        }
        catch (InvocationTargetException e) {
            this.cancel();
            Throwable cause = e.getCause();
            if (cause instanceof ExpiredTextBufferException) {
                throw (ExpiredTextBufferException)cause;
            }
            if (cause instanceof CancellationException) {
                throw (CancellationException)cause;
            }
            if (cause instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)cause;
            }
            this.reportVisitorException(method.getTarget(), method.getMethod(), arguments[1], e);
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.cancel();
            this.reportVisitorException(method.getTarget(), method.getMethod(), arguments[1], e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.invokedMethod = null;
        }
    }

    void exitContext() {
        this.issueCollector.exitingContext(this);
        this.model = null;
        this.location = null;
        this.construct = null;
        this.disabledAnalyzers.clear();
        this.arguments[1] = null;
        this.attributes = null;
        this.childAttributes = null;
    }

    @Override
    public Auditor getAuditor() {
        return this.auditor;
    }

    @Override
    public AuditContext getEnclosingContext() {
        return this.enclosingContext;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    boolean isRoot() {
        return this.isAuditRoot;
    }

    boolean isModelRoot() {
        return this.enclosingContext == null || this.enclosingContext.construct instanceof ModelAdapter;
    }

    @Override
    public Workspace getWorkspace() {
        if (this.model == null) {
            throw new IllegalStateException("model null");
        }
        return this.model.getWorkspace();
    }

    @Override
    public Project getProject() {
        if (this.model == null) {
            throw new IllegalStateException("model null");
        }
        return this.model.getProject();
    }

    @Override
    public Node getNode() {
        if (this.model == null) {
            throw new IllegalStateException("model null");
        }
        return this.model.getNode();
    }

    @Override
    public Context getIdeContext() {
        return this.model.getIdeContext();
    }

    @Override
    public Set<String> getTechnologies() {
        if (this.model == null) {
            throw new IllegalStateException("model null");
        }
        return this.auditor.getTechnologies(this.model.getWorkspace(), this.model.getProject());
    }

    @Override
    public URL getUrl() {
        return this.model.getUrl();
    }

    @Override
    public ModelAdapter getModel() {
        if (this.model == null && this.depth > 0) {
            throw new IllegalStateException("model null");
        }
        return this.model;
    }

    @Override
    public Location getLocation() {
        if (this.location == null) {
            if (this.model == null) {
                throw new IllegalStateException("model null");
            }
            if (this.construct == null) {
                throw new IllegalStateException("construct null");
            }
            this.location = this.model.getLocation(this.construct);
            if (this.location == null) {
                throw this.model.createModelAccessError(this);
            }
        }
        return this.location;
    }

    @Override
    public Object getConstruct() {
        if (this.model == null) {
            throw new IllegalStateException("model null");
        }
        return this.construct;
    }

    @Override
    public Class<?> getPresentationType() {
        if (this.model == null) {
            throw new IllegalStateException("model null");
        }
        return this.presentationType;
    }

    @Override
    public String getText() {
        Location location = this.getLocation();
        return this.model.getText(location.getOffset(), location.getLength());
    }

    @Override
    public int getLineOffset() {
        Location location = this.getLocation();
        return this.model.getLineOffset(location.getOffset());
    }

    @Override
    public int getOffset() {
        return this.getLocation().getOffset();
    }

    @Override
    public int getLength() {
        return this.getLocation().getLength();
    }

    @Override
    public boolean isCancelled() {
        return this.auditor.isCancelled();
    }

    @Override
    public void throwIfCancelled() {
        this.auditor.throwIfCancelled();
    }

    @Override
    public Location getLocation(Object construct) {
        if (this.model == null) {
            throw new IllegalStateException("model null");
        }
        Location location = construct instanceof ModelAdapter ? ((ModelAdapter)construct).getLocation() : (construct == null ? this.getLocation() : this.model.getLocation(construct));
        return location;
    }

    @Override
    public String getText(Object construct) {
        if (this.model == null) {
            throw new IllegalStateException("model null");
        }
        Location location = this.model.getLocation(construct);
        return this.model.getText(location.getOffset(), location.getLength());
    }

    @Override
    public <T extends ModelAdapter> ModelAdapter getModel(Class<T> type, URL url, Project project, Workspace workspace) {
        return this.model.getFactory().getModelAdapter(type, url, project, workspace);
    }

    @Override
    public <T extends ModelAdapter> ModelAdapter getModel(Class<T> type, URL url) {
        return this.getModel(type, url, this.getProject(), this.getWorkspace());
    }

    @Override
    public AuditContext.Key key(Object object) {
        return new DefaultKey(object, this.attributeCount.postincrement());
    }

    @Override
    public AuditContext.Key sharedKey(Object object) {
        AuditContext.Key key = this.sharedAttributes.get(object);
        if (key != null) {
            return key;
        }
        key = new DefaultKey(object, this.attributeCount.postincrement());
        this.sharedAttributes.put(object, key);
        return key;
    }

    @Override
    public void setAttribute(AuditContext.Key key, Object value) {
        if (key == null) {
            throw new NullArgumentException("key cannot be null");
        }
        if (value == null) {
            value = NULL_VALUE;
        }
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        this.attributes.set(key.hashCode(), value);
    }

    @Override
    public void setAttribute(AuditContext.Key key, int value) {
        this.setAttribute(key, (Object)value);
    }

    @Override
    public void setAttribute(AuditContext.Key key, float value) {
        this.setAttribute(key, new Float(value));
    }

    @Override
    public Object getAttribute(AuditContext.Key key) {
        if (key == null) {
            throw new NullArgumentException("key cannot be null");
        }
        int index = key.hashCode();
        DefaultAuditContext context = this;
        do {
            Object value;
            if (context.attributes == null || (value = context.attributes.get(index)) == null) continue;
            return value != NULL_VALUE ? value : null;
        } while ((context = context.enclosingContext) != null);
        return null;
    }

    @Override
    public int getAttribute(AuditContext.Key key, int defaultValue) {
        Object value = this.getAttribute(key);
        if (value == null) {
            return defaultValue;
        }
        return ((Number)value).intValue();
    }

    @Override
    public float getAttribute(AuditContext.Key key, float defaultValue) {
        Object value = this.getAttribute(key);
        if (value == null) {
            return defaultValue;
        }
        return ((Number)value).floatValue();
    }

    @Override
    public void setChildAttribute(Object child, AuditContext.Key key, Object value) {
        Attributes attributes;
        if (child == null) {
            throw new NullArgumentException("child cannot be null");
        }
        if (key == null) {
            throw new NullArgumentException("key cannot be null");
        }
        Location location = this.getLocation(child);
        int index = key.hashCode();
        if (this.childAttributes == null) {
            this.childAttributes = new HashMap<Location, Attributes>();
            attributes = new Attributes();
            this.childAttributes.put(location, attributes);
        } else {
            attributes = this.childAttributes.get(location);
            if (attributes == null) {
                attributes = new Attributes();
                this.childAttributes.put(location, attributes);
            }
        }
        if (value == null) {
            value = NULL_VALUE;
        }
        attributes.set(index, value);
    }

    @Override
    public void setParentAttribute(AuditContext.Key key, Object value) {
        if (this.enclosingContext != null) {
            this.enclosingContext.setAttribute(key, value);
        }
    }

    @Override
    public Object getChildAttribute(Object child, AuditContext.Key key) {
        if (child == null) {
            throw new NullArgumentException("child cannot be null");
        }
        if (key == null) {
            throw new NullArgumentException("key cannot be null");
        }
        Location location = this.getLocation(child);
        int index = key.hashCode();
        if (this.childAttributes == null) {
            return null;
        }
        Attributes attributes = this.childAttributes.get(location);
        if (attributes == null) {
            return null;
        }
        Object value = attributes.get(index);
        return value != NULL_VALUE ? value : null;
    }

    @Override
    public void enableGetChildAttribute() {
        if (this.enclosingContext == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        if (this.enclosingContext.childAttributes == null) {
            this.enclosingContext.childAttributes = new HashMap<Location, Attributes>();
        }
        this.enclosingContext.childAttributes.put(this.getLocation(), this.attributes);
    }

    @Override
    public void addDependency(Dependency dependency) {
        this.auditor.addDependency(dependency);
    }

    @Override
    public IssueReport report(Rule rule) {
        if (rule == null || !rule.isEnabled() && !"oracle.ide.audit.internal".equals(rule.category().id())) {
            return NULL_ISSUE_REPORT;
        }
        return this.issueCollector.openIssue(this, rule, this.getLocation(), this.construct);
    }

    @Override
    public IssueReport report(Rule rule, Object construct) {
        Location location;
        if (construct == null) {
            this.reportCallerException((Throwable)new NullArgumentException("null construct reported for rule " + rule));
            return NULL_ISSUE_REPORT;
        }
        Location location2 = location = construct == this.model ? this.model.getLocation() : this.model.getLocation(construct);
        if (location == null) {
            this.reportCallerException((Throwable)new NullArgumentException("construct '" + construct + "' outside " + this.model + " reported for rule " + rule));
            return NULL_ISSUE_REPORT;
        }
        if (rule == null || !rule.isEnabled() && !"oracle.ide.audit.internal".equals(rule.category().id())) {
            return NULL_ISSUE_REPORT;
        }
        return this.issueCollector.openIssue(this, rule, location, construct);
    }

    @Override
    public IssueReport report(Rule rule, ModelAdapter model, Object construct) {
        return this.report(rule, construct);
    }

    @Override
    public IssueReport report(Rule rule, Location location) {
        if (rule == null || !rule.isEnabled() && !"oracle.ide.audit.internal".equals(rule.category().id())) {
            return NULL_ISSUE_REPORT;
        }
        if (location == null) {
            this.reportCallerException((Throwable)new NullArgumentException("null location reported for rule " + rule));
            return NULL_ISSUE_REPORT;
        }
        return this.issueCollector.openIssue(this, rule, location, null);
    }

    @Override
    public SuppressionReport report(SuppressionScheme scheme, String name, Object construct) {
        Location location;
        if (scheme == null || !scheme.isEnabled()) {
            return NULL_SUPPRESSION_REPORT;
        }
        if (construct == null) {
            this.reportCallerException((Throwable)new NullArgumentException("null construct reported for " + name + " in scheme " + scheme.id()));
            return NULL_SUPPRESSION_REPORT;
        }
        Location location2 = location = construct == this.model ? this.model.getLocation() : this.model.getLocation(construct);
        if (location == null) {
            this.reportCallerException((Throwable)new NullArgumentException("construct '" + construct + "' outside " + this.model + " reported for " + name + " in scheme " + scheme.id()));
            return NULL_SUPPRESSION_REPORT;
        }
        return this.issueCollector.openNameSuppression(this, scheme, name, location, construct);
    }

    @Override
    public SuppressionReport report(SuppressionScheme scheme, String name, Location location) {
        if (scheme == null || !scheme.isEnabled()) {
            return NULL_SUPPRESSION_REPORT;
        }
        if (location == null) {
            this.reportCallerException((Throwable)new NullArgumentException("null location reported for " + name + " in scheme " + scheme.id()));
            return NULL_SUPPRESSION_REPORT;
        }
        return this.issueCollector.openNameSuppression(this, scheme, name, location, null);
    }

    @Override
    public SuppressionReport report(SuppressionScheme scheme, Violation issue) {
        if (scheme == null || !scheme.isEnabled()) {
            return NULL_SUPPRESSION_REPORT;
        }
        if (issue == null) {
            this.reportCallerException((Throwable)new NullArgumentException("null issue reported for scheme " + scheme.id()));
            return NULL_SUPPRESSION_REPORT;
        }
        return this.issueCollector.openReviewSuppression(this, scheme, issue);
    }

    @Override
    public void markSuppressionLimit() {
        int offset = this.getOffset();
        this.issueCollector.markSuppressionLimit(offset);
    }

    public void cancel() {
        this.issueCollector.cancel();
    }

    void reportTraversalException(Throwable exception, Object construct) {
        for (int i = 0; exception instanceof InvocationTargetException && i < 32; ++i) {
            exception = exception.getCause();
        }
        if (exception instanceof InvocationTargetException) {
            AuditLogger.error("exception has getCause chain > 32", new Object[0]);
        }
        if (this.location == null && (this.model == null || this.getLocation() == null || this.location.getModel() == null)) {
            if (this.enclosingContext != null && !(exception instanceof VirtualMachineError)) {
                this.enclosingContext.reportTraversalException(exception, construct);
            } else {
                AuditLogger.error(exception, "exception traversing {0}{1}{2}", construct, Strings.LINE_SEPARATOR, "null location in context");
            }
            return;
        }
        if (exception instanceof ModelAccessError) {
            this.issueCollector.reportModelError(this, exception, construct);
        } else {
            AuditLogger.error(exception, "exception traversing {0}{1}{2}", construct, Strings.LINE_SEPARATOR, this.location.getModel().contextDescription(this.location));
            this.issueCollector.reportTraversalException(this, exception, construct);
        }
    }

    void reportCallerException(Throwable exception) {
        Analyzer analyzer = this.invokedMethod.getTarget();
        for (int i = 0; exception instanceof InvocationTargetException && i < 32; ++i) {
            exception = exception.getCause();
        }
        if (exception instanceof InvocationTargetException) {
            AuditLogger.error("exception has getCause chain > 32", new Object[0]);
        }
        if (this.location == null) {
            if (this.model != null && this.construct != null) {
                this.location = this.model.getLocation(this.construct);
            }
            if (this.location == null && this.enclosingContext != null) {
                if (!this.enclosingContext.model.equals(this.model)) {
                    this.location = this.model.getLocation();
                } else {
                    this.enclosingContext.reportCallerException(exception);
                    return;
                }
            }
        }
        AuditLogger.log(exception, "analyzer", (Object)analyzer, "caller", this.model, this.location, new Object[0]);
    }

    void reportVisitorException(Analyzer analyzer, Method method, Object construct, Throwable exception) {
        analyzer.setEnabled(false);
        for (int i = 0; exception instanceof InvocationTargetException && i < 32; ++i) {
            exception = exception.getCause();
        }
        if (exception instanceof InvocationTargetException) {
            AuditLogger.error("exception has getCause chain > 32", new Object[0]);
        }
        Location location = this.getLocation();
        if (exception instanceof VirtualMachineError) {
            AuditLogger.log(exception, "analyzer", (Object)analyzer, "visitor", this.model, location, new Object[0]);
            return;
        }
        if (location == null && (this.model == null || this.getLocation() == null || location.getModel() == null)) {
            if (this.enclosingContext != null) {
                this.enclosingContext.reportVisitorException(analyzer, method, construct, exception);
            } else {
                AuditLogger.log(exception, "analyzer", (Object)analyzer, "visitor", this.model, location, new Object[0]);
            }
            return;
        }
        AuditLogger.log(exception, "analyzer", (Object)analyzer, "visitor", this.model, location, new Object[0]);
        Rule visitorExceptionRule = CoreBeans.visitorExceptionRule();
        if (visitorExceptionRule != null) {
            IssueReport report = construct == null ? this.report(visitorExceptionRule, location) : this.report(visitorExceptionRule, construct);
            report.addParameter("exception", exception.toString());
            StackTraceElement[] trace = exception.getStackTrace();
            if (trace.length > 0) {
                report.addParameter("method", Strings.lastToken(trace[0].getClassName(), ".") + '.' + trace[0].getMethodName() + ':' + trace[0].getLineNumber());
            } else {
                report.addParameter("method", "?");
            }
            report.addParameter("analyzerClass", analyzer.getClass().getName());
            report.addParameter("analyzerMethod", method.getName());
            report.addParameter("analyzerArgument", construct.getClass().getSimpleName());
        }
        ArrayList<Rule> rules = new ArrayList<Rule>();
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        ArrayList<SuppressionScheme> suppressionSchemes = new ArrayList<SuppressionScheme>();
        boolean success = this.auditor.getProfileBinding().enabledBeans(analyzer, rules, metrics, suppressionSchemes);
        if (success && rules.size() + metrics.size() + suppressionSchemes.size() > 0) {
            IssueReport report;
            StringBuilder builder;
            DefaultAuditContext root = this;
            while (!root.isRoot()) {
                if ((root = (DefaultAuditContext)root.getEnclosingContext()) != null) continue;
                root = this;
                break;
            }
            String analyzerName = analyzer.getClass().getName();
            if (!rules.isEmpty()) {
                builder = new StringBuilder();
                for (Rule rule : rules) {
                    if (builder.length() > 0) {
                        builder.append(", ");
                    }
                    builder.append(rule.label());
                }
                AuditLogger.error("disabling analyzer {0}; rules {1}", analyzerName, builder);
                Rule disabledRulesRule = CoreBeans.disabledRulesRule();
                if (disabledRulesRule != null) {
                    report = this.report(disabledRulesRule, root.getLocation());
                    report.addParameter("analyzerClass", analyzerName);
                    report.addParameter("rules", builder.toString());
                }
            }
            if (!metrics.isEmpty()) {
                builder = new StringBuilder();
                for (Metric metric : metrics) {
                    if (builder.length() == 0) {
                        builder.append(", ");
                    }
                    builder.append(metric.label());
                }
                AuditLogger.error("disabling analyzer {0}; metrics {1}", analyzerName, builder);
                Rule disabledMetricsRule = CoreBeans.disabledMetricsRule();
                if (disabledMetricsRule != null) {
                    report = this.report(disabledMetricsRule, root.getLocation());
                    report.addParameter("analyzerClass", analyzerName);
                    report.addParameter("metrics", builder.toString());
                }
            }
            if (!suppressionSchemes.isEmpty()) {
                builder = new StringBuilder();
                for (SuppressionScheme scheme : suppressionSchemes) {
                    if (builder.length() > 0) {
                        builder.append(", ");
                    }
                    builder.append(scheme.label());
                }
                AuditLogger.error("disabling analyzer {0}; suppression schemes {1}", analyzerName, builder);
                Rule disabledSchemesRule = CoreBeans.disabledSuppressionSchemesRule();
                if (disabledSchemesRule != null) {
                    report = this.report(disabledSchemesRule, root.getLocation());
                    report.addParameter("analyzerClass", analyzerName);
                    report.addParameter("schemes", builder.toString());
                }
            }
        }
    }

    @Override
    public void report(Metric metric, Object measurement) {
        if (!metric.isEnabled()) {
            return;
        }
        this.listeners.fireValueReported(this.getLocation(), metric, measurement);
    }

    @Override
    public void report(Metric metric, int measurement) {
        this.report(metric, (Object)measurement);
    }

    @Override
    public void report(Metric metric, float measurement) {
        this.report(metric, (Object)new Float(measurement));
    }

    @Override
    public void produceFragment(Class<? extends ModelType> fragmentType) {
        this.produceFragment(fragmentType, this.getLocation());
    }

    @Override
    public void produceFragment(Class<? extends ModelType> fragmentType, Object construct) {
        Location location = this.getLocation(construct);
        if (location == null) {
            throw new IllegalArgumentException("construct not in model " + this.model + ": " + construct);
        }
        this.produceFragment(fragmentType, location);
    }

    @Override
    public void produceFragment(Class<? extends ModelType> fragmentType, Location location) {
        if (location == null) {
            throw new NullArgumentException("location");
        }
        if (location.getModel() != this.model) {
            throw new IllegalArgumentException(location + " model must be " + this.model);
        }
        this.auditor.produceFragment(fragmentType, location);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "[" + this.model.getShortLabel() + ", " + this.construct + ", depth " + this.depth + "]";
    }

    @Override
    public ModelAdapter getModelAdapter() {
        return this.getModel();
    }

    @Override
    public <T extends ModelAdapter> ModelAdapter getModelAdapter(Class<T> type, URL url, Project project, Workspace workspace) {
        return this.getModel(type, url, project, workspace);
    }

    @Override
    public <T extends ModelAdapter> ModelAdapter getModelAdapter(Class<T> type, URL url) {
        return this.getModel(type, url, this.getProject(), this.getWorkspace());
    }

    private class Attributes {
        private Object[] array;

        private Attributes() {
        }

        public void set(int index, Object value) {
            assert (index < DefaultAuditContext.this.attributeCount.intValue()) : "index " + index + " count " + DefaultAuditContext.access$100(DefaultAuditContext.this);
            if (this.array == null) {
                this.array = new Object[DefaultAuditContext.this.attributeCount.intValue()];
            } else if (index >= this.array.length) {
                Object[] old = this.array;
                this.array = new Object[DefaultAuditContext.this.attributeCount.intValue()];
                System.arraycopy(old, 0, this.array, 0, old.length);
            }
            this.array[index] = value;
        }

        public Object get(int index) {
            assert (index < DefaultAuditContext.this.attributeCount.intValue()) : "index " + index + " count " + DefaultAuditContext.access$100(DefaultAuditContext.this);
            if (this.array == null || index >= this.array.length) {
                return null;
            }
            return this.array[index];
        }

        public void clear() {
            this.array = null;
        }
    }

    private static class DefaultKey
    implements AuditContext.Key {
        private Object name;
        private int index;

        public DefaultKey(Object name, int index) {
            LOG.trace("created key {0}, {1}", index, name);
            this.name = name;
            this.index = index;
        }

        public boolean equals(Object object) {
            return object instanceof DefaultKey && this.index == ((DefaultKey)object).index;
        }

        public int hashCode() {
            return this.index;
        }

        public String toString() {
            return String.valueOf(this.name);
        }
    }
}

