/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.util.Arrays;
import java.util.Map;
import oracle.jdeveloper.audit.analyzer.Category;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.SuppressionScheme;
import oracle.jdeveloper.audit.extension.AuditHook;
import oracle.jdeveloper.audit.extension.BeanDefinition;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdevimpl.audit.core.CountColumn;
import oracle.jdevimpl.audit.core.DefaultExtensionBeanFactory;
import oracle.jdevimpl.audit.core.SeverityColumn;

class CoreBeans {
    private static final String ANALYZER_EXCEPTION = "oracle.ide.audit.analyzer-exception";
    private static final String TRAVERSAL_EXCEPTION = "oracle.ide.audit.traversal-exception";
    private static final String VISITOR_EXCEPTION = "oracle.ide.audit.visitor-exception";
    private static final String DISABLED_RULES = "oracle.ide.audit.disabled-rules";
    private static final String DISABLED_METRICS = "oracle.ide.audit.disabled-metrics";
    private static final String DISABLED_SUPPRESSION_SCHEMES = "oracle.ide.audit.disabled-suppression-schemes";
    private static final String MODEL_ERROR = "oracle.ide.audit.model-error";
    private static final String SEVERITY = "oracle.ide.audit.severity";
    private static final String VISIBLE_ISSUES = "oracle.ide.audit.visible-issues";
    private static final String ISSUES = "oracle.ide.audit.issues";
    private static final String[] IDS = new String[]{"oracle.ide.audit.analyzer-exception", "oracle.ide.audit.traversal-exception", "oracle.ide.audit.visitor-exception", "oracle.ide.audit.disabled-rules", "oracle.ide.audit.disabled-metrics", "oracle.ide.audit.disabled-suppression-schemes", "oracle.ide.audit.model-error", "oracle.ide.audit.severity", "oracle.ide.audit.visible-issues", "oracle.ide.audit.issues"};
    private static Map<String, ExtensionBean> beans;

    CoreBeans() {
    }

    static Rule analyzerExceptionRule() {
        return (Rule)CoreBeans.bean(ANALYZER_EXCEPTION);
    }

    static Rule traversalExceptionRule() {
        return (Rule)CoreBeans.bean(TRAVERSAL_EXCEPTION);
    }

    static Rule visitorExceptionRule() {
        return (Rule)CoreBeans.bean(VISITOR_EXCEPTION);
    }

    static Rule disabledRulesRule() {
        return (Rule)CoreBeans.bean(DISABLED_RULES);
    }

    static Rule disabledMetricsRule() {
        return (Rule)CoreBeans.bean(DISABLED_METRICS);
    }

    static Rule disabledSuppressionSchemesRule() {
        return (Rule)CoreBeans.bean(DISABLED_SUPPRESSION_SCHEMES);
    }

    static Rule modelErrorRule() {
        return (Rule)CoreBeans.bean(MODEL_ERROR);
    }

    static SeverityColumn severityColumn() {
        return (SeverityColumn)CoreBeans.bean(SEVERITY);
    }

    static CountColumn visibleIssuesColumn() {
        return (CountColumn)CoreBeans.bean(VISIBLE_ISSUES);
    }

    static CountColumn issuesColumn() {
        return (CountColumn)CoreBeans.bean(ISSUES);
    }

    private static synchronized <T extends ExtensionBean> T bean(String id) {
        if (beans == null) {
            Object[] definitions = AuditHook.getAuditHook().getBeansByIdOrDeprecatedId(IDS);
            if (definitions.length != IDS.length) {
                String message = "Audit core bean definitions missing: expected " + Arrays.toString(IDS) + "; actual " + Arrays.toString(definitions);
                AuditLogger.error(new Throwable(message), message, new Object[0]);
            }
            beans = new DefaultExtensionBeanFactory((BeanDefinition<?>[])definitions).getBeans(true);
            int categoryCount = 0;
            for (ExtensionBean bean : beans.values()) {
                if (bean instanceof Rule) {
                    ((Rule)bean).setEnabled(true);
                    continue;
                }
                if (bean instanceof Metric) {
                    ((Metric)bean).setEnabled(true);
                    continue;
                }
                if (bean instanceof SuppressionScheme) {
                    ((SuppressionScheme)bean).setEnabled(true);
                    continue;
                }
                if (!(bean instanceof Category)) continue;
                ++categoryCount;
            }
            if (beans.size() - categoryCount != definitions.length) {
                String message = "Audit core beans missing: expected " + Arrays.toString(definitions) + "; actual " + beans;
                AuditLogger.error(new Throwable(message), message, new Object[0]);
            }
        }
        return (T)beans.get(id);
    }
}

