/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.transform;

import java.net.URL;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.vcs.VCSManager;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.DirectoryTransformContext;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformAdapter;
import oracle.jdeveloper.audit.transform.TransformContext;
import oracle.jdeveloper.audit.transform.TransformSequenceContext;

public class DirectoryTransformAdapter
extends TransformAdapter {
    @Override
    protected TransformContext createContext(TransformContext.Shape shape, Transform transform, Violation violation, Location location, URL pendingLocation, Project pendingProject, Workspace pendingWorkspace) {
        return new DirectoryTransformContext(this, shape, transform, violation, location, pendingLocation, pendingProject, pendingWorkspace);
    }

    @Override
    public boolean isTransformable(ModelAdapter model) {
        URL url = model.getUrl();
        return URLFileSystem.canWrite((URL)url) || VCSManager.getVCSManager().isVersioned(url);
    }

    @Override
    public Boolean makeTransformable(TransformContext context) throws Exception {
        URL url = context.getModel().getUrl();
        return URLFileSystem.canWrite((URL)url) || URLFileSystem.canCreate((URL)url);
    }

    @Override
    public void beginTransformSequence(TransformSequenceContext sequenceContext) {
    }

    @Override
    public void beginTransform(TransformContext context) {
    }

    @Override
    public void endTransform(TransformContext context) {
    }

    @Override
    public void cancelTransform(TransformContext context) {
    }

    @Override
    public void cancelTransformSequence(TransformSequenceContext sequenceContext) {
    }

    @Override
    public void endTransformSequence(TransformSequenceContext sequenceContext) {
    }
}

