/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.project;

import java.lang.reflect.Method;
import java.net.URL;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.project.ProjectTransformContext;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformAdapter;
import oracle.jdeveloper.audit.transform.TransformContext;

public class ProjectTransformAdapter
extends TransformAdapter {
    private ReadWriteLock nodeLock;
    private static Method lockMethod;

    @Override
    protected TransformContext createContext(TransformContext.Shape shape, Transform transform, Violation violation, Location location, URL pendingLocation, Project pendingProject, Workspace pendingWorkspace) {
        return new ProjectTransformContext(this, shape, transform, violation, location, pendingLocation, pendingProject, pendingWorkspace);
    }

    @Override
    public void beginTransform(TransformContext context) {
        this.getLock(context).writeLock();
    }

    @Override
    public void endTransform(TransformContext context) throws Exception {
        this.getLock(context).writeUnlock();
    }

    @Override
    public void cancelTransform(TransformContext context) throws Exception {
        this.getLock(context).writeUnlock();
    }

    private synchronized ReadWriteLock getLock(TransformContext context) {
        if (this.nodeLock == null) {
            Project node = context.getProject();
            if (node == null) {
                throw new NullPointerException("ProjectTransformContext has no project");
            }
            try {
                if (lockMethod == null) {
                    lockMethod = Node.class.getDeclaredMethod("nodeLock", null);
                    lockMethod.setAccessible(true);
                }
                this.nodeLock = (ReadWriteLock)lockMethod.invoke((Object)node, null);
            }
            catch (Throwable e) {
                throw new UnexpectedExceptionError(e);
            }
        }
        return this.nodeLock;
    }
}

