/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.model.Project;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.extension.AuditHook;
import oracle.jdeveloper.audit.extension.Trigger;
import oracle.jdeveloper.audit.model.TechnologyScopeDependency;

public class TechnologyScopeListener
extends StructureChangeListener {
    private static final Map<Project, TechnologyScopeListener> listeners = new IdentityHashMap<Project, TechnologyScopeListener>();
    private static final Log LOCK_LOG = new Log("status-lock");
    private final Project project;
    private volatile ListStructure structure;
    private volatile HashStructure rootStructure;
    private final List<TechnologyScopeDependency> dependencies = new ArrayList<TechnologyScopeDependency>();
    private static final Log LOG = new Log("dependency");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDependency(TechnologyScopeDependency dependency) {
        TechnologyScopeListener listener;
        Project project = dependency.getProject();
        Map<Project, TechnologyScopeListener> map = listeners;
        synchronized (map) {
            listener = listeners.get(project);
            if (listener == null) {
                listener = new TechnologyScopeListener(project);
                listeners.put(project, listener);
            }
        }
        listener.bind(dependency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDependency(TechnologyScopeDependency dependency) {
        boolean removed;
        TechnologyScopeListener listener;
        Project project = dependency.getProject();
        Map<Project, TechnologyScopeListener> map = listeners;
        synchronized (map) {
            listener = listeners.get(project);
        }
        if (listener != null && (removed = listener.unbind(dependency))) {
            Map<Project, TechnologyScopeListener> map2 = listeners;
            synchronized (map2) {
                listeners.remove(project);
            }
        }
    }

    public TechnologyScopeListener(Project project) {
        this.project = project;
    }

    private synchronized boolean bind(TechnologyScopeDependency dependency) {
        boolean firstDependency = this.dependencies.isEmpty();
        if (firstDependency) {
            LOG.trace("******** adding structure listener {0}", (Object)this);
            this.structure = this.project.getSharedPropertiesOnly().getListStructure(TechnologyScopeConfiguration.TECHNOLOGY_SCOPE_KEY);
            if (this.structure == null) {
                this.rootStructure = this.project.getSharedPropertiesOnly();
                this.rootStructure.addStructureChangeListener((StructureChangeListener)this);
            } else {
                this.structure.addStructureChangeListener((StructureChangeListener)this);
            }
        }
        this.dependencies.add(dependency);
        return firstDependency;
    }

    private synchronized boolean unbind(TechnologyScopeDependency dependency) {
        this.dependencies.remove(dependency);
        boolean lastDependency = this.dependencies.isEmpty();
        if (lastDependency) {
            LOG.trace("******** removing structure listener {0}", (Object)this);
            if (this.rootStructure != null) {
                this.rootStructure.removeStructureChangeListener((StructureChangeListener)this);
                this.rootStructure = null;
            }
            if (this.structure != null) {
                this.structure.removeStructureChangeListener((StructureChangeListener)this);
                this.structure = null;
            }
        }
        return lastDependency;
    }

    public void structureValuesChanged(StructureChangeEvent e) {
        if (!this.project.isOpen()) {
            LOCK_LOG.trace("structure changed in {0}, closed: \"{1}\"", (Object)this, (Object)e);
            return;
        }
        HashSet<String> changedTechnologies = new HashSet<String>();
        boolean technologiesAdded = false;
        if (this.structure == null) {
            for (ChangeInfo change : e.getChangeDetails()) {
                if (!change.getPropertyName().startsWith(TechnologyScopeConfiguration.TECHNOLOGY_SCOPE_KEY)) continue;
                this.structure = this.rootStructure.getListStructure(TechnologyScopeConfiguration.TECHNOLOGY_SCOPE_KEY);
                if (this.structure == null) break;
                this.rootStructure.removeStructureChangeListener((StructureChangeListener)this);
                this.rootStructure = null;
                this.structure.addStructureChangeListener((StructureChangeListener)this);
                changedTechnologies.addAll((Collection<String>)this.structure);
                technologiesAdded = !this.structure.isEmpty();
                break;
            }
        } else {
            block5: for (ChangeInfo change : e.getChangeDetails()) {
                switch (change.getChangeType()) {
                    case 1: {
                        changedTechnologies.add(change.getNewValueAsString());
                        technologiesAdded = true;
                        continue block5;
                    }
                    case 3: {
                        changedTechnologies.add(change.getOldValueAsString());
                    }
                }
            }
        }
        assert (!technologiesAdded || !changedTechnologies.isEmpty());
        if (!changedTechnologies.isEmpty()) {
            boolean triggerMatched = false;
            if (technologiesAdded) {
                HashSet<String> technologies = new HashSet<String>();
                for (Object item : this.structure) {
                    technologies.add(((String)item).trim());
                }
                for (Trigger trigger : AuditHook.getAuditHook().getUnloadedTriggers()) {
                    if (!trigger.matches(technologies)) continue;
                    triggerMatched = true;
                    break;
                }
            }
            for (TechnologyScopeDependency dependency : this.dependencies) {
                Collection<String> technologies = dependency.getTechnologies();
                if (technologies == null) {
                    if (!triggerMatched) continue;
                    dependency.fireDependencyChanged(true);
                    continue;
                }
                if (Collections.disjoint(changedTechnologies, technologies)) continue;
                dependency.fireDependencyChanged(true);
            }
        }
        LOCK_LOG.trace("structure changed in {0}, open, changed {1}: \"{2}\"", (Object)this, changedTechnologies, (Object)e);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " " + this.structure + " (" + this.project.getShortLabel() + ")";
    }
}

