/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import java.util.Arrays;
import java.util.Collection;
import oracle.ide.model.Project;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.TechnologyScopeListener;

public class TechnologyScopeDependency
extends Dependency {
    private final Project project;
    private final Collection<String> technologies;
    private static final Log LOG = new Log("dependency");

    public TechnologyScopeDependency(Project project) {
        this.project = project;
        this.technologies = null;
    }

    public TechnologyScopeDependency(Project project, String ... technologies) {
        if (technologies == null) {
            throw new IllegalArgumentException("technologies null");
        }
        if (technologies.length == 0) {
            throw new IllegalArgumentException("technologies empty");
        }
        this.project = project;
        this.technologies = Arrays.asList(technologies);
    }

    public Project getProject() {
        return this.project;
    }

    public Collection<String> getTechnologies() {
        return this.technologies;
    }

    @Override
    protected void attach() {
        LOG.trace("attaching {0}", (Object)this);
        TechnologyScopeListener.addDependency(this);
    }

    @Override
    protected void detach() {
        LOG.trace("detaching {0}", (Object)this);
        TechnologyScopeListener.removeDependency(this);
    }

    @Override
    protected String getShortDescription() {
        return this.project.getShortLabel();
    }

    @Override
    protected String getLongDescription() {
        return this.project.getLongLabel();
    }
}

