/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import java.util.Arrays;
import oracle.ide.config.Preferences;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.DependencyStructureListener;

public class StructureDependency
extends Dependency {
    private final PropertyStorage container;
    private final HashStructureAdapter scope;
    private final String[] properties;
    private static final Log LOG = new Log("dependency");

    public StructureDependency(Preferences preferences, String ... properties) {
        this(preferences, (HashStructureAdapter)null, properties);
    }

    public StructureDependency(Preferences preferences, HashStructureAdapter scope, String ... properties) {
        this((PropertyStorage)preferences, scope, properties);
    }

    public StructureDependency(Workspace workspace, String ... properties) {
        this((PropertyStorage)workspace, null, properties);
    }

    public StructureDependency(Workspace workspace, HashStructureAdapter scope, String ... properties) {
        this((PropertyStorage)workspace, scope, properties);
    }

    public StructureDependency(Project project, String ... properties) {
        this(project, (HashStructureAdapter)null, properties);
    }

    public StructureDependency(Project project, HashStructureAdapter scope, String ... properties) {
        this((PropertyStorage)project, scope, properties);
    }

    public StructureDependency(PropertyStorage container, HashStructureAdapter scope, String ... properties) {
        if (container == null) {
            throw new IllegalArgumentException("container == null");
        }
        this.container = container;
        this.scope = scope;
        this.properties = properties;
        LOG.trace("created {0}", (Object)this);
    }

    @Override
    protected void attach() {
        LOG.trace("attaching {0}", (Object)this);
        DependencyStructureListener.addDependency(this, this.container, this.scope, this.properties);
    }

    @Override
    protected void detach() {
        LOG.trace("detaching {0}", (Object)this);
        DependencyStructureListener.removeDependency(this, this.container, this.scope, this.properties);
    }

    @Override
    protected String getShortDescription() {
        StringBuilder builder = new StringBuilder();
        if (this.container instanceof DataContainer) {
            builder.append(((DataContainer)this.container).getShortLabel());
        } else {
            builder.append(this.container.getClass().getSimpleName());
        }
        builder.append(' ');
        if (this.scope != null) {
            builder.append("(");
            builder.append(this.scope.getClass().getSimpleName());
            builder.append(") ");
        }
        builder.append(Arrays.asList(this.properties));
        return builder.toString();
    }

    @Override
    protected String getLongDescription() {
        return this.getLongDescription();
    }
}

