/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import java.net.URL;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.DependencyFileChangeListener;
import oracle.jdeveloper.audit.model.DependencyTextBufferListener;

public class FileDependency
extends Dependency {
    private URL file;
    private Project project;
    private Workspace workspace;
    private boolean modifySensitive = true;
    private static final Log LOG = new Log("dependency");

    public FileDependency(URL file, Project project, Workspace workspace) {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        this.file = file;
        this.project = project;
        this.workspace = workspace;
        LOG.trace("created {0}", (Object)this);
    }

    public void setModifySensitive(boolean sensitive) {
        if (this.isAttached()) {
            throw new IllegalStateException(this + " already attached");
        }
        this.modifySensitive = sensitive;
    }

    public boolean isModifySensitive() {
        return this.modifySensitive;
    }

    public URL getFile() {
        return this.file;
    }

    public Project getProject() {
        return this.project;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    protected void attach() {
        LOG.trace("attaching {0}", (Object)this);
        if (this.modifySensitive) {
            DependencyTextBufferListener.addDependency(this, this.file);
        }
        DependencyFileChangeListener.addDependency((Dependency)this, this.file, this.project, this.workspace);
    }

    @Override
    protected void detach() {
        LOG.trace("detaching {0}", (Object)this);
        DependencyFileChangeListener.removeDependency((Dependency)this, this.file, this.project, this.workspace);
        if (this.modifySensitive) {
            DependencyTextBufferListener.removeDependency(this, this.file);
        }
    }

    @Override
    protected String getShortDescription() {
        return URLFileSystem.getFileName((URL)this.file) + (this.modifySensitive ? " (changes ignored)" : "");
    }

    @Override
    protected String getLongDescription() {
        return URLFileSystem.getPlatformPathName((URL)this.file) + (this.modifySensitive ? " (changes ignored)" : "");
    }
}

