/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.ide.model.DataContainer;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.Structure;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.service.AuditLogger;

public class DependencyStructureListener
extends StructureChangeListener {
    private static final Map<PropertyStorage, DependencyStructureListener> listeners = new IdentityHashMap<PropertyStorage, DependencyStructureListener>();
    private static final Log LOCK_LOG = new Log("status-lock");
    private final PropertyStorage container;
    private final List<DependencyBinding> bindings = new ArrayList<DependencyBinding>();
    private Structure structure1;
    private Structure structure2;
    private static final Log LOG = new Log("dependency");
    private static final ConcurrentHashMap<Class<? extends HashStructureAdapter>, Method> getters = new ConcurrentHashMap();
    private static final Method NULL_METHOD;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDependency(Dependency dependency, PropertyStorage container, HashStructureAdapter scope, String ... properties) {
        DependencyStructureListener listener;
        Map<PropertyStorage, DependencyStructureListener> map = listeners;
        synchronized (map) {
            listener = listeners.get(container);
            if (listener == null) {
                listener = new DependencyStructureListener(container);
                listeners.put(container, listener);
            }
        }
        listener.bind(dependency, scope, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDependency(Dependency dependency, PropertyStorage container, HashStructureAdapter scope, String ... properties) {
        boolean removed;
        DependencyStructureListener listener;
        Map<PropertyStorage, DependencyStructureListener> map = listeners;
        synchronized (map) {
            listener = listeners.get(container);
        }
        if (listener != null && (removed = listener.unbind(dependency, scope, properties))) {
            Map<PropertyStorage, DependencyStructureListener> map2 = listeners;
            synchronized (map2) {
                listeners.remove(container);
            }
        }
    }

    public DependencyStructureListener(PropertyStorage container) {
        this.container = container;
    }

    private synchronized boolean bind(Dependency dependency, HashStructureAdapter scope, String[] properties) {
        DependencyBinding binding = new DependencyBinding(dependency, scope, properties);
        boolean added = this.bindings.isEmpty();
        if (added) {
            LOG.trace("******** adding structure listener {0}", (Object)this);
            if (this.container instanceof DataContainer) {
                this.structure1 = ((DataContainer)this.container).getSharedPropertiesOnly();
                HashStructure userProperties = ((DataContainer)this.container).getUserPropertiesOnly();
                if (userProperties != null && userProperties != this.structure1) {
                    this.structure2 = userProperties;
                    this.structure2.addStructureChangeListener((StructureChangeListener)this);
                }
            } else {
                this.structure1 = this.container.getProperties();
            }
            this.structure1.addStructureChangeListener((StructureChangeListener)this);
        }
        this.bindings.add(binding);
        return added;
    }

    private synchronized boolean unbind(Dependency dependency, HashStructureAdapter scope, String[] properties) {
        DependencyBinding binding = new DependencyBinding(dependency, scope, properties);
        this.bindings.remove(binding);
        boolean removed = this.bindings.isEmpty();
        if (removed) {
            LOG.trace("******** removing structure listener {0}", (Object)this);
            this.structure1.removeStructureChangeListener((StructureChangeListener)this);
            if (this.structure2 != null) {
                this.structure2.removeStructureChangeListener((StructureChangeListener)this);
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void structureValuesChanged(StructureChangeEvent e) {
        if (this.container instanceof DataContainer && !((DataContainer)this.container).isOpen()) {
            LOCK_LOG.trace("structure changed in {0}, closed: \"{1}\"", (Object)this, (Object)e);
            return;
        }
        ArrayList<Dependency> changed = new ArrayList<Dependency>();
        DependencyStructureListener dependencyStructureListener = this;
        synchronized (dependencyStructureListener) {
            block3: for (DependencyBinding binding : this.bindings) {
                for (ChangeInfo change : e.getChangeDetails()) {
                    if (change.getChangeType() == 2 || !binding.applies(change)) continue;
                    changed.add(binding.dependency);
                    continue block3;
                }
            }
        }
        for (Dependency dependency : changed) {
            dependency.fireDependencyChanged(true);
        }
        LOCK_LOG.trace("structure changed in {0}, open, change {1}: \"{2}\"", (Object)this, (Object)(!changed.isEmpty() ? 1 : 0), (Object)e);
    }

    public String toString() {
        String name = this.container instanceof DataContainer ? ((DataContainer)this.container).getShortLabel() : this.container.getClass().getName();
        return ((Object)((Object)this)).getClass().getSimpleName() + "  (" + name + ")";
    }

    private static String prefix(HashStructureAdapter scope) {
        if (scope == null) {
            return "";
        }
        Class<?> type = scope.getClass();
        Method getter = getters.get(type);
        if (getter == NULL_METHOD) {
            return null;
        }
        if (getter == null) {
            while (true) {
                try {
                    getter = type.getDeclaredMethod("getHashStructure", new Class[0]);
                    getter.setAccessible(true);
                    getters.put(scope.getClass(), getter);
                }
                catch (NoSuchMethodException e) {
                    if (type.getClass() == HashStructureAdapter.class) {
                        AuditLogger.error(e, "getHashStructure not found in {0}: {1}", scope.getClass(), e);
                        getters.put(scope.getClass(), NULL_METHOD);
                        return null;
                    }
                    type = type.getSuperclass();
                    continue;
                }
                catch (Exception e) {
                    AuditLogger.error(e, "Exception finding getHashStructure in {0}: {1}", type, e);
                    getters.put(scope.getClass(), NULL_METHOD);
                    return null;
                }
                break;
            }
        }
        try {
            String name = ((HashStructure)getter.invoke((Object)scope, new Object[0])).getFullName();
            return name == null ? "" : (name.endsWith("/") ? name : name + '/');
        }
        catch (Exception e) {
            AuditLogger.error(e, "Exception getting hash structure from {0} using {1}: {2}", scope, getter, e);
            return null;
        }
    }

    static {
        try {
            NULL_METHOD = DependencyStructureListener.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class DependencyBinding {
        private final Dependency dependency;
        private final String prefix;
        private final String[] properties;

        private DependencyBinding(Dependency dependency, HashStructureAdapter scope, String[] properties) {
            this.dependency = dependency;
            this.prefix = DependencyStructureListener.prefix(scope);
            this.properties = properties;
        }

        public boolean applies(ChangeInfo change) {
            String name;
            if (this.prefix != null && (name = change.getPropertyName()).startsWith(this.prefix)) {
                if (this.properties.length == 0) {
                    return true;
                }
                for (String property : this.properties) {
                    if (!name.regionMatches(this.prefix.length(), property, 0, property.length())) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean equals(Object object) {
            if (!(object instanceof DependencyBinding)) {
                return false;
            }
            DependencyBinding that = (DependencyBinding)object;
            return this.dependency.equals(that.dependency) && this.prefix != null ? this.prefix.equals(that.prefix) : that.prefix == null;
        }

        public int hashCode() {
            return this.dependency.hashCode() * 37 + (this.prefix != null ? this.prefix.hashCode() : 0);
        }
    }
}

