/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import java.util.ArrayList;
import java.util.Collection;
import oracle.javatools.util.NullArgumentException;
import oracle.jdeveloper.audit.extension.BeanDefinition;
import oracle.jdeveloper.audit.extension.DefinitionContext;
import oracle.jdeveloper.audit.extension.ExtensionBundle;
import oracle.jdeveloper.audit.transform.Transform;

public class TransformDefinition
extends BeanDefinition<Transform> {
    public static final String BOUND_LABEL_KEY = "bound-label";
    private Collection<TransformDefinition> transforms = NO_TRANSFORMS;
    private static final Collection<TransformDefinition> NO_TRANSFORMS = new ArrayList<TransformDefinition>();

    public TransformDefinition(String id, ExtensionBundle bundle, DefinitionContext context) {
        super(id, bundle, context);
    }

    @Override
    public Class<Transform> getDefaultImplementationClass() {
        return Transform.class;
    }

    @Override
    public boolean hasEnabledProperty() {
        return true;
    }

    public boolean isComposite() {
        return !this.transforms.isEmpty();
    }

    public void setTransforms(Collection<TransformDefinition> transforms) {
        if (transforms == null) {
            throw new NullArgumentException("transforms null");
        }
        if (this.transforms != NO_TRANSFORMS) {
            throw new IllegalStateException("transforms already set");
        }
        this.transforms = transforms;
    }

    public Collection<TransformDefinition> getTransforms() {
        return this.transforms;
    }

    public String boundLabel(String variation) {
        String label = null;
        if (variation != null) {
            label = this.string(variation + "." + BOUND_LABEL_KEY);
        }
        if (label == null) {
            label = this.string(BOUND_LABEL_KEY);
        }
        if (label == null && variation != null) {
            label = this.string(variation + "." + "label");
        }
        if (label == null) {
            label = this.label();
        }
        return label;
    }
}

