/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.jdeveloper.audit.extension.DefinitionContext;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.extension.ExtensionBundle;
import oracle.jdeveloper.audit.extension.TopLevelDefinition;
import oracle.jdeveloper.audit.extension.TypeDefinition;
import oracle.jdeveloper.audit.extension.Value;

public abstract class BeanDefinition<T extends ExtensionBean>
extends TopLevelDefinition {
    private TypeDefinition<T> implementationClass;
    private List<Value> values;

    BeanDefinition(String id, ExtensionBundle bundle, DefinitionContext context) {
        super(id, bundle, context);
    }

    public abstract boolean hasEnabledProperty();

    public boolean isEnabledByDefault() {
        if (!this.hasEnabledProperty()) {
            throw new UnsupportedOperationException("isEnabled");
        }
        Value value = this.getValue("enabled");
        return value != null && "true".equalsIgnoreCase(value.getText());
    }

    public TypeDefinition<T> getImplementationClass() {
        return this.implementationClass;
    }

    public abstract Class<? extends ExtensionBean> getDefaultImplementationClass();

    public void setImplementationClass(TypeDefinition implementationClass) {
        this.implementationClass = implementationClass;
    }

    public Collection<Value> getValues() {
        return this.values;
    }

    public Value getValue(String name) {
        if (this.values == null) {
            return null;
        }
        for (Value value : this.values) {
            if (!name.equals(value.getName())) continue;
            return value;
        }
        return null;
    }

    public void setValues(Collection<Value> values) {
        if (this.values != null) {
            throw new IllegalStateException("values already set");
        }
        if (values == null || values.isEmpty()) {
            return;
        }
        this.values = new ArrayList<Value>(values);
        Collections.sort(this.values);
    }

    public void setValue(Value value) {
        if (this.values == null) {
            this.values = new ArrayList<Value>();
            this.values.add(value);
        } else {
            assert (!this.values.isEmpty());
            for (int i = 0; i < this.values.size(); ++i) {
                int comparison = value.compareTo(this.values.get(i));
                if (comparison > 0) continue;
                if (comparison == 0) {
                    this.values.set(i, value);
                } else {
                    this.values.add(i, value);
                }
                return;
            }
            assert (value.compareTo(this.values.get(this.values.size() - 1)) > 0);
            this.values.add(value);
        }
    }
}

