/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.bean;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;

public abstract class PropertyItem {
    private String name;
    private String labelText;
    private int mnemonic;
    private int mnemonicIndex = -1;
    private JLabel label;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLabelText(String text) {
        this.labelText = text;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(int mnemonic) {
        this.mnemonic = mnemonic;
        if (this.label != null) {
            this.label.setDisplayedMnemonic(mnemonic);
        }
    }

    public int getMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public void setMnemonicIndex(int index) {
        this.mnemonicIndex = index;
        if (this.label != null) {
            this.label.setDisplayedMnemonicIndex(index);
        }
    }

    public abstract JComponent getComponent();

    public int getComponentBaseline() {
        return PropertyItem.baseline(this.getComponent());
    }

    public boolean getComponentTracksContainerWidth() {
        return false;
    }

    public JLabel getLabel() {
        if (this.label == null) {
            String labelText = this.getLabelText();
            if (labelText != null && labelText.charAt(labelText.length() - 1) != ':') {
                labelText = labelText + ':';
            }
            this.label = new JLabel(labelText);
            JComponent component = this.getComponent();
            this.label.setLabelFor(component);
            int mnemonic = this.getMnemonic();
            if (mnemonic != 0) {
                this.label.setDisplayedMnemonic(mnemonic);
                if (this.mnemonicIndex >= 0) {
                    this.label.setDisplayedMnemonicIndex(this.mnemonicIndex);
                }
            }
        }
        return this.label;
    }

    protected static int baseline(JComponent component) {
        Dimension preferredSize = component.getPreferredSize();
        return component.getBaseline(preferredSize.width, preferredSize.height);
    }
}

