/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.analyzer;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import oracle.jdeveloper.audit.analyzer.Category;
import oracle.jdeveloper.audit.analyzer.Parameter;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.extension.SuppressionSchemeDefinition;
import oracle.jdeveloper.audit.transform.Transform;

public class SuppressionScheme
extends ExtensionBean {
    public static final int MAX_TRANSFORM_COUNT = 15;
    private Category category;
    private boolean enabled;
    private Parameter[] parameters;
    private Transform[] transforms = NO_TRANSFORMS;
    private static final Transform[] NO_TRANSFORMS = new Transform[0];

    @Override
    protected void copyInternalState(ExtensionBean copy, Map<String, ExtensionBean> context) throws InvocationTargetException {
        SuppressionScheme scheme = (SuppressionScheme)copy;
        if (this.category != null) {
            scheme.category = (Category)this.category.createCopy(context);
        }
        scheme.parameters = this.parameters;
        int length = this.transforms.length;
        if (length > 0) {
            scheme.transforms = new Transform[length];
            for (int i = 0; i < length; ++i) {
                Transform transform = this.transforms[i];
                scheme.transforms[i] = (Transform)transform.createCopy(null);
            }
        } else {
            scheme.transforms = NO_TRANSFORMS;
        }
    }

    public SuppressionSchemeDefinition definition() {
        return (SuppressionSchemeDefinition)super.definition();
    }

    public Category category() {
        return this.category;
    }

    public Parameter[] parameters() {
        return this.parameters;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean newValue) {
        boolean oldValue = this.enabled;
        this.enabled = newValue;
        this.firePropertyChange("enabled", oldValue, newValue);
    }

    public final Transform[] getTransforms() {
        return this.transforms;
    }

    public String toString() {
        if (this.isEnabled()) {
            return "suppression type " + this.id();
        }
        return "suppression type " + this.id() + " (disabled)";
    }
}

