/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.analyzer;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import oracle.jdeveloper.audit.analyzer.Category;
import oracle.jdeveloper.audit.analyzer.Parameter;
import oracle.jdeveloper.audit.analyzer.Severity;
import oracle.jdeveloper.audit.analyzer.StyleCategory;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.extension.RuleDefinition;
import oracle.jdeveloper.audit.extension.Value;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;

public class Rule
extends ExtensionBean {
    public static final int MAX_TRANSFORM_COUNT = 15;
    private Severity severity;
    private StyleCategory style;
    private Category category;
    private boolean enabled;
    private Parameter[] parameters;
    private Transform[] transforms = NO_TRANSFORMS;
    private Transform defaultTransform;
    private static final Transform[] NO_TRANSFORMS = new Transform[0];

    @Override
    protected void copyInternalState(ExtensionBean copy, Map<String, ExtensionBean> context) throws InvocationTargetException {
        Rule rule = (Rule)copy;
        if (this.category != null) {
            rule.category = (Category)this.category.createCopy(context);
        }
        rule.parameters = this.parameters;
        int length = this.transforms.length;
        if (length > 0) {
            rule.transforms = new Transform[length];
            for (int i = 0; i < length; ++i) {
                rule.transforms[i] = (Transform)this.transforms[i].createCopy(null);
                if (this.transforms[i] != this.defaultTransform) continue;
                rule.defaultTransform = rule.transforms[i];
            }
        } else {
            rule.transforms = NO_TRANSFORMS;
        }
    }

    public RuleDefinition definition() {
        return (RuleDefinition)super.definition();
    }

    public final boolean mandatoryError() {
        return this.definition().isMandatoryError();
    }

    public final boolean assist() {
        return this.severity == Severity.ASSIST;
    }

    public Category category() {
        return this.category;
    }

    public Parameter[] parameters() {
        return this.parameters;
    }

    public Collection<String> variations() {
        return this.definition().getVariations();
    }

    public String[] messages() {
        return this.definition().messages();
    }

    public String message(Violation violation) {
        RuleDefinition definition = this.definition();
        String message = definition.message(violation.getVariation());
        return message != null ? definition.bind(message, violation, false) : this.syntheticMessage(violation);
    }

    public String htmlMessage(Violation violation) {
        RuleDefinition definition = this.definition();
        String message = definition.htmlMessage(violation.getVariation());
        return message != null ? definition.bind(message, violation, false) : this.syntheticMessage(violation);
    }

    private String syntheticMessage(Violation violation) {
        StringBuilder builder = new StringBuilder();
        builder.append("Rule '");
        builder.append(this.label());
        builder.append("' violated");
        int count = violation.getParameterCount();
        if (count > 0) {
            builder.append(": ");
            for (int i = 0; i < count; ++i) {
                if (count > 0) {
                    builder.append(", ");
                }
                builder.append(violation.getParameterName(i));
                builder.append("=\"");
                builder.append(violation.getParameterValue(i));
                builder.append("\"");
            }
        }
        return builder.toString();
    }

    public final Transform getDefaultTransform() {
        return this.defaultTransform;
    }

    public void setDefaultTransformName(String id) {
        Transform oldTransform = this.defaultTransform;
        ExtensionBean newTransform = null;
        if (id != null) {
            for (Transform transform : this.transforms) {
                if (!transform.id().equals(id) && !transform.definition().getDeprecatedIds().contains(id)) continue;
                newTransform = transform;
                break;
            }
        }
        this.defaultTransform = newTransform;
        this.firePropertyChange("defaultTransformName", oldTransform != null ? oldTransform.id() : null, newTransform != null ? newTransform.id() : null);
    }

    public String getDefaultTransformName() {
        return this.defaultTransform != null ? this.defaultTransform.id() : null;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean newValue) {
        boolean oldValue = this.enabled;
        this.enabled = newValue;
        this.firePropertyChange("enabled", oldValue, newValue);
    }

    public final Severity getSeverity() {
        if (this.severity == null) {
            Value value = this.definition().getValue("severity");
            if (value != null) {
                this.severity = Severity.valueOf(value.getText());
            }
            if (this.severity == null) {
                this.severity = Severity.ADVISORY;
            }
        }
        return this.severity;
    }

    public final void setSeverity(Severity newValue) {
        if (this.mandatoryError() && newValue != Severity.ERROR) {
            return;
        }
        Severity oldValue = this.severity;
        this.severity = newValue;
        this.firePropertyChange("severity", oldValue, newValue);
    }

    public final StyleCategory getStyle() {
        if (this.style == null) {
            Severity severity = this.getSeverity();
            this.style = severity == Severity.ERROR ? StyleCategory.ERROR : (severity == Severity.WARNING ? StyleCategory.WARNING : (severity == Severity.INCOMPLETE ? StyleCategory.INCOMPLETE : (severity == Severity.ADVISORY ? StyleCategory.ADVISORY : StyleCategory.ASSIST)));
        }
        return this.style;
    }

    public final void setStyle(StyleCategory newValue) {
        assert (newValue != null);
        StyleCategory oldValue = this.getStyle();
        this.style = newValue;
        this.firePropertyChange("style", oldValue, newValue);
    }

    public final Transform[] getTransforms() {
        return this.transforms;
    }

    public String toString() {
        if (this.isEnabled()) {
            return "rule " + this.id();
        }
        return "rule " + this.id() + " (disabled)";
    }
}

