/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.TPDBResultSetModel;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.panels.sql.tester.TesterComponent;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;
import oracle.jdevimpl.db.resource.UISQLDevBundle;

public class ResultSetTesterComponent
extends TesterComponent {
    private final JPanel m_panel = new JPanel(new BorderLayout());
    private final ResultSetTable m_table = new ResultSetTable();

    public ResultSetTesterComponent() {
        this.m_panel.setName("ResultSetTesterComponent");
        this.m_table.setName("ResultSetTesterComponent.ResultSetTable");
    }

    public Component getComponent() {
        return this.m_panel;
    }

    public String getName() {
        return UISQLDevBundle.get("QUERY_RESULTS");
    }

    public void close() {
        this.m_panel.removeAll();
        try {
            this.m_table.closeModel();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void testSQL(Database database, String string) {
        this.close();
        if (database != null) {
            try {
                if (database.getConnectionStore() == null) {
                    ModelImpl modelImpl = new ModelImpl(database);
                    modelImpl.init(string, this.getBindVariables(database, string));
                    this.m_table.setModel((TableModel)((Object)modelImpl));
                } else {
                    this.m_table.setQuery(database.getQualifiedName(), string, null, this.getBindVariables(database, string));
                }
                this.showOnPanel(new JScrollPane((Component)this.m_table), "Center");
                this.m_table.open(false);
            }
            catch (ExecutionException executionException) {
                this.fail(executionException.getCause());
            }
            catch (Throwable throwable) {
                this.fail(throwable);
            }
        }
    }

    private void fail(Throwable throwable) {
        String string = UISQLDevBundle.format("QUERY_RESULTS_ERROR", throwable.getMessage());
        if (!(throwable instanceof SQLException)) {
            DBLog.getLogger((Object)((Object)this)).log(Level.SEVERE, "Execute failed in ResultSetTable", throwable);
        }
        this.close();
        JWrappedLabel jWrappedLabel = new JWrappedLabel(string);
        jWrappedLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.showOnPanel((Component)jWrappedLabel, "North");
    }

    private void showOnPanel(Component component, Object object) {
        this.m_panel.removeAll();
        this.m_panel.add(component, object);
        this.m_panel.validate();
        this.m_panel.repaint();
    }

    private class ModelImpl
    extends TPDBResultSetModel {
        private final Database m_db;

        ModelImpl(Database database) {
            this.m_db = database;
        }

        protected Connection getConnection() throws DBException {
            return this.m_db.getConnection(false);
        }

        void init(String string, Map<String, ?> map) {
            String string2 = DatabaseFactory.encodeIdentifier((String)ResultSetTesterComponent.this.getTester().getDefaultConnectionStore(), (String)this.m_db.getConnectionName());
            super.init(string, string2, null, map);
        }
    }
}

