/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.xml.navigator;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.xml.navigator.CategoryElement;
import oracle.dbtools.xml.navigator.ConnectionTypeElement;
import oracle.dbtools.xml.navigator.Descriptor;
import oracle.dbtools.xml.navigator.NavigatorXmlElements;
import oracle.dbtools.xml.navigator.ObjectTypeElement;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;

public final class NavigatorDescriptorFile
implements NavigatorXmlElements {
    private final String resourceKey;
    private final List<ConnectionTypeElement> connectionTypes;
    private final List<ObjectTypeElement> types;
    private final List<CategoryElement> categories;

    public static NavigatorDescriptorFile createDescriptor(XMLDocument doc) {
        NavigatorDescriptorFile desc = null;
        XMLNode navNode = (XMLNode)XMLHelper.getChildNode((Node)doc, "navigator");
        if (navNode != null) {
            desc = new NavigatorDescriptorFile(navNode);
        }
        return desc;
    }

    private NavigatorDescriptorFile(XMLNode node) {
        this.resourceKey = XMLHelper.getAttributeNode((Node)node, "RESOURCE_FILE");
        ArrayList<ConnectionTypeElement> l = new ArrayList<ConnectionTypeElement>();
        XMLNode[] nl = XMLHelper.getChildNodes((Node)node, "connection");
        if (nl != null && nl.length > 0) {
            for (int i = 0; i < nl.length; ++i) {
                l.add(new ConnectionTypeElement(nl[i]));
            }
        }
        this.connectionTypes = l.size() > 0 ? l : null;
        l = new ArrayList();
        for (XMLNode n : Descriptor.getElements("/navigator/objectType", node)) {
            l.add((ConnectionTypeElement)((Object)new ObjectTypeElement(n)));
        }
        this.types = l.size() > 0 ? l : null;
        l = new ArrayList();
        for (XMLNode n : Descriptor.getElements("/navigator/categoryType", node)) {
            l.add((ConnectionTypeElement)((Object)new CategoryElement(n)));
        }
        this.categories = l.size() > 0 ? l : null;
    }

    public List<ObjectTypeElement> getTypes() {
        return Descriptor.wrapList(this.types);
    }

    public List<CategoryElement> getCategories() {
        return Descriptor.wrapList(this.categories);
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public List<ConnectionTypeElement> getConnectionTypes() {
        return Descriptor.wrapList(this.connectionTypes);
    }
}

