/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.xml.actions;

import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.xml.actions.ItemsElement;
import oracle.dbtools.xml.actions.TypedElement;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;

public class ActionFolderElement
extends ItemsElement
implements TypedElement {
    private final String name;
    private final String type;
    private final Double weight;

    ActionFolderElement(XMLNode node) {
        super(node);
        XMLNode titleElement = (XMLNode)XMLHelper.getChildNode((Node)node, "name");
        this.name = titleElement != null ? titleElement.getTextContent() : null;
        this.type = XMLHelper.getAttributeNode((Node)node, "type");
        String weightStr = XMLHelper.getAttributeNode((Node)node, "weight");
        if (weightStr != null) {
            Double parsedWeight;
            try {
                parsedWeight = Double.parseDouble(weightStr);
            }
            catch (NumberFormatException nfe) {
                parsedWeight = Double.NaN;
            }
            this.weight = parsedWeight;
        } else {
            this.weight = 1.0;
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public Double getWeight() {
        return this.weight;
    }
}

