/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.test;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.script.Bindings;
import javax.script.ScriptException;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.scripting.GlobalMap;
import oracle.dbtools.scripting.Scripting;
import oracle.dbtools.util.Service;

public abstract class Base
extends Scripting {
    public static Integer singleTest = null;
    private static int maxTestNo = 0;
    public static Set<Integer> failedTests = new TreeSet<Integer>();
    public boolean printOKTests = false;
    Set<RuleTuple> rules;
    Earley earley;
    protected int assertion;
    protected int comment;
    protected int code;
    protected int dotted_name;
    protected int digits;
    protected int element;
    protected int output;
    protected int inputSql;
    protected int result;
    protected int identifier;
    protected int parameters;
    protected int program;
    protected int quoted_string;
    protected int StringLiteral;
    private String input;

    public Base(String testFile) throws FileNotFoundException, IOException {
        this(testFile, "common/src/test/resources/oracle/dbtools/test/base.grammar", "common/src/main/resources/oracle/dbtools/parser/js/js.grammar");
    }

    public Base(String testFile, String basePath, String jsPath) throws FileNotFoundException, IOException {
        this.input = Service.readFile(testFile);
        Object testGrammar = Service.readFile(basePath);
        testGrammar = (String)testGrammar + Service.readFile(jsPath);
        testGrammar = (String)testGrammar + Service.readFile(Program.class, "arbori.grammar");
        this.rules = Base.rules((String)testGrammar);
        this.earley = new Earley(this.rules){

            @Override
            protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
                LexerToken token = src.get(y);
                return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == Base.this.code && token.type == Token.DQUOTED_STRING || symbol == Base.this.code && token.type == Token.BQUOTED_STRING || symbol == Base.this.StringLiteral && token.type == Token.DQUOTED_STRING || symbol == Base.this.quoted_string && token.type == Token.QUOTED_STRING;
            }
        };
        this.output = (Integer)this.earley.symbolIndexes.get("output");
        this.assertion = (Integer)this.earley.symbolIndexes.get("assertion");
        this.inputSql = (Integer)this.earley.symbolIndexes.get("inputSql");
        this.code = (Integer)this.earley.symbolIndexes.get("code");
        this.comment = (Integer)this.earley.symbolIndexes.get("comment");
        this.result = (Integer)this.earley.symbolIndexes.get("result");
        this.element = (Integer)this.earley.symbolIndexes.get("element");
        this.dotted_name = (Integer)this.earley.symbolIndexes.get("dotted_name");
        this.identifier = (Integer)this.earley.symbolIndexes.get("identifier");
        this.parameters = (Integer)this.earley.symbolIndexes.get("parameters");
        this.program = (Integer)this.earley.symbolIndexes.get("program");
        this.quoted_string = (Integer)this.earley.symbolIndexes.get("quoted_string");
        this.digits = (Integer)this.earley.symbolIndexes.get("digits");
        this.StringLiteral = (Integer)this.earley.symbolIndexes.get("StringLiteral");
    }

    public boolean test() throws Exception {
        List<LexerToken> src = LexerToken.parse(this.input, "`#", 57);
        Matrix matrix = new Matrix(this.earley);
        Visual visual = null;
        if (src.size() < 100) {
            visual = new Visual(src, this.earley);
        }
        this.earley.parse(src, matrix);
        SyntaxError s = SyntaxError.checkSyntax(this.input, new String[]{"atest"}, src, this.earley, matrix);
        if (s != null) {
            if (visual != null) {
                visual.draw(matrix);
            }
            System.err.println("Syntax Error");
            System.err.println("at line#" + s.line);
            System.err.println(s.code);
            System.err.println(s.marker);
            System.err.println("Expected:  ");
            for (String tmp : s.getSuggestions()) {
                System.err.print(tmp + ",");
            }
            throw new Exception(">>>> syntactically invalid code fragment <<<<");
        }
        ParseNode root = this.earley.forest(src, matrix);
        if (src.size() < 100) {
            root.printTree();
        }
        long t1 = System.currentTimeMillis();
        this.atest(root, src, this.input);
        long t2 = System.currentTimeMillis();
        System.out.println("Total test time = " + (t2 - t1));
        if (failedTests.size() != 0) {
            System.err.println("*** TEST FAILED! *** ---> " + failedTests.toString());
            return false;
        }
        System.out.println("*** ALL " + maxTestNo + " TESTS are OK *** ---> ");
        return true;
    }

    private static Set<RuleTuple> rules(String input) {
        try {
            List<LexerToken> src = Lexer.parse(input, false, 49);
            ParseNode root = Grammar.parseGrammarFile(src, input);
            TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
            Grammar.grammar(root, src, ret);
            RuleTransforms.eliminateEmptyProductions(ret);
            return ret;
        }
        catch (Exception e) {
            throw new AssertionError((Object)"VT: failed to init grammar for regression test");
        }
    }

    private void atest(ParseNode root, List<LexerToken> src, String input) throws Exception {
        if (root.contains("jsBlock")) {
            String code = input.substring(src.get((int)root.from).end, src.get((int)(root.to - 1)).begin);
            try {
                GlobalMap _globals = this.getGlobals();
                if (_globals == null) {
                    return;
                }
                this.getEngine().eval(code, (Bindings)this.getGlobals());
            }
            catch (ScriptException e) {
                throw e;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return;
        }
        if (root.contains(this.assertion)) {
            if (singleTest != null && singleTest != maxTestNo) {
                return;
            }
            if (this.printOKTests) {
                System.out.print("TEST#" + maxTestNo + " -> ");
            }
            if (this.assertion(root, src, input, maxTestNo)) {
                if (this.printOKTests) {
                    System.out.println("OK \n");
                }
            } else if (this.printOKTests) {
                System.out.println("*** Failed ***\n");
            }
            return;
        }
        if (root.contains(this.output)) {
            if (singleTest != null && singleTest != maxTestNo) {
                return;
            }
            if (this.printOKTests) {
                System.out.print("TEST#" + maxTestNo + " -> ");
            }
            this.output(root, src, input, maxTestNo);
            return;
        }
        if (root.contains(this.comment)) {
            Base.comment(root, src, input);
            return;
        }
        for (ParseNode child : root.children()) {
            this.atest(child, src, input);
        }
    }

    protected void output(ParseNode root, List<LexerToken> src, String input, int testNum) throws SQLException {
        for (ParseNode child : root.children()) {
            if (child.contains(this.parameters)) {
                this.parameters(child, src, input);
                continue;
            }
            if (!child.contains(this.inputSql)) continue;
            System.out.println("TEST#" + maxTestNo + " ->\n" + this.query(child, src, input));
        }
    }

    protected boolean assertion(ParseNode root, List<LexerToken> src, String input, int testNum) throws Exception {
        List<String> output = null;
        Map<Object, Object> cmp = new HashMap();
        for (ParseNode child : root.children()) {
            if (child.contains(this.parameters)) {
                this.parameters(child, src, input);
                continue;
            }
            if (child.contains(this.inputSql)) {
                output = this.query(child, src, input);
                continue;
            }
            if (child.contains(this.result)) {
                cmp = this.result(child, src, input);
                continue;
            }
            if (!child.contains(this.program)) continue;
            this.program(child, src, input, output.get(0));
        }
        for (String c : cmp.keySet()) {
            boolean isPositive = (Boolean)cmp.get(c);
            String cC = c.replace("\r", "");
            boolean isCaseSensitive = false;
            if (cC.charAt(0) == '\"') {
                isCaseSensitive = true;
            }
            if (cC.charAt(0) == '`') {
                cC = cC.substring(1, cC.length() - 1);
            }
            if (!isCaseSensitive) {
                cC = cC.toLowerCase();
            }
            boolean matched = false;
            String prefix = this.longestCommonPrefix(cC, "");
            String str1 = "";
            String str2 = "";
            for (String o : output) {
                String oO = o.replace("\r", "");
                if (isCaseSensitive && oO.charAt(0) != '\"') {
                    oO = this.quoteOutput(oO);
                }
                if (!isCaseSensitive) {
                    oO = oO.toLowerCase();
                }
                if (cC.equals(oO)) {
                    matched = true;
                    break;
                }
                String p = this.longestCommonPrefix(cC, oO);
                if (prefix.length() >= p.length()) continue;
                prefix = p;
                int index1 = prefix.length() + 3;
                if (oO.length() < index1) {
                    index1 = oO.length();
                }
                str1 = oO.substring(prefix.length(), index1);
                int index2 = prefix.length() + 3;
                if (cC.length() < index2) {
                    index2 = cC.length();
                }
                str2 = cC.substring(prefix.length(), index2);
            }
            if ((matched || !isPositive) && (!matched || isPositive)) continue;
            System.out.println((isPositive ? "no" : "unexpected") + " match for " + c);
            failedTests.add(testNum);
            if (cC.contains("\n")) {
                System.out.println(prefix + ">>>" + str1 + "!=" + str2);
            }
            return false;
        }
        return true;
    }

    protected String quoteOutput(String output) {
        return "\"" + output + "\"";
    }

    protected void parameters(ParseNode node, List<LexerToken> src, String input) {
    }

    protected Map<String, Boolean> result(ParseNode node, List<LexerToken> src, String input) {
        if (node.contains(this.element)) {
            return this.element(node, src, input);
        }
        HashMap<String, Boolean> output = new HashMap<String, Boolean>();
        for (ParseNode child : node.children()) {
            output.putAll(this.result(child, src, input));
        }
        return output;
    }

    private Map<String, Boolean> element(ParseNode node, List<LexerToken> src, String input) {
        HashMap<String, Boolean> output = new HashMap<String, Boolean>();
        if (node.contains(this.dotted_name) || node.contains(this.code)) {
            String current = node.content(src);
            output.put(current, true);
            return output;
        }
        for (ParseNode child : node.children()) {
            if (!child.contains(this.dotted_name)) continue;
            String current = child.content(src);
            output.put(current, false);
            return output;
        }
        return output;
    }

    protected List<String> query(ParseNode root, List<LexerToken> src, String input) throws SQLException {
        if (root.contains(this.code)) {
            return this.output(Base.sql_fragment(root, src, input), -1);
        }
        String lhs = "";
        String rhs = "";
        for (ParseNode child : root.children()) {
            if (!child.contains(this.code)) continue;
            if (lhs == "") {
                lhs = Base.sql_fragment(child, src, input);
                continue;
            }
            rhs = Base.sql_fragment(child, src, input);
        }
        return this.output(lhs + rhs, lhs.length());
    }

    protected void program(ParseNode node, List<LexerToken> src, String input, String sql) throws Exception {
        String arbori = input.substring(src.get((int)node.from).begin, src.get((int)(node.to - 1)).end);
        SqlProgram r = new SqlProgram(arbori, "JS", this.getEngine(), this.getGlobals(), true){};
        Map<String, MaterializedPredicate> output = r.run(sql, null, "JS action");
        if (this.getGlobals().get("debug") != null) {
            for (String p : output.keySet()) {
                System.out.println(p + "=" + output.get(p).toString(p.length() + 1));
            }
        }
    }

    public abstract List<String> output(String var1, int var2);

    private static String sql_fragment(ParseNode root, List<LexerToken> src, String input) {
        return input.substring(src.get((int)root.from).begin, src.get((int)(root.to - 1)).end).replace("`", "");
    }

    private static ParseNode comment(ParseNode root, List<LexerToken> src, String input) throws Exception {
        int testNo;
        String txt = input.substring(src.get((int)(root.from + 1)).begin, src.get((int)(root.to - 1)).end - 1);
        if (txt.charAt(0) == '+') {
            txt = txt.substring(1);
        }
        if (maxTestNo < (testNo = Integer.parseInt(txt))) {
            maxTestNo = testNo;
        }
        if (singleTest != null && singleTest != testNo) {
            return null;
        }
        return null;
    }

    private String longestCommonPrefix(String a, String b) {
        int minLength = Math.min(a.length(), b.length());
        for (int i = 0; i < minLength; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return a.substring(0, i);
        }
        return a.substring(0, minLength);
    }
}

