/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils.oerr;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.raptor.utils.oerr.GetFile;
import oracle.dbtools.raptor.utils.oerr.Messages;
import oracle.dbtools.raptor.utils.oerr.SAXHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class WriteXML {
    private DocumentBuilderFactory factory = null;
    private DocumentBuilder builder = null;
    private Document document = null;
    private Document indexDocument = null;
    private Document sequenceDocument = null;
    private Element root = null;
    private Element indexRoot = null;
    private Element sequenceRoot = null;
    private SAXParserFactory _factory;
    private URL indexDirectory;
    private String localBaseName = null;
    private String localFileSequence = null;
    private String localLanguage = null;

    public static void main(String[] args) throws Exception {
        WriteXML wxml = new WriteXML();
        wxml.doit();
        wxml.getora("002");
    }

    public void setupIndexFile(String results) {
        try {
            this.indexDirectory = new URL(results);
            if (this.factory == null) {
                this.factory = DocumentBuilderFactory.newInstance();
                this.factory.setCoalescing(true);
                this.builder = this.factory.newDocumentBuilder();
            }
            this.indexDocument = this.builder.newDocument();
            this.indexRoot = this.indexDocument.createElement("index");
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public void startSequenceFile(String baseName, String fileSequence, String language) {
        try {
            this.localBaseName = baseName;
            this.localFileSequence = fileSequence;
            this.localLanguage = language;
            if (this.factory == null) {
                this.factory = DocumentBuilderFactory.newInstance();
                this.factory.setCoalescing(true);
                this.builder = this.factory.newDocumentBuilder();
            }
            this.sequenceDocument = this.builder.newDocument();
            this.sequenceRoot = this.sequenceDocument.createElement(baseName.substring(baseName.lastIndexOf(47) + 1));
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public void addIndexLine(String baseName, String fileSequence, String language, String min, String max) {
        Element fileIndex = this.indexDocument.createElement("fileIndex");
        fileIndex.setAttribute("basename", baseName);
        fileIndex.setAttribute("sequence", fileSequence);
        fileIndex.setAttribute("language", language);
        fileIndex.setAttribute("min", min);
        fileIndex.setAttribute("max", max);
        this.indexRoot.appendChild(fileIndex);
    }

    void getora(String getme) {
        this.setupSax(getme);
    }

    void getByIndex(String results, String baseName, String errNo) {
        try {
            this.indexDirectory = new URL(results);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        long start = System.currentTimeMillis();
        String sequenceFile = this.getIndexFile(false, baseName, errNo);
        System.out.println(Messages.getString("WriteXML.9") + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.outputMatch(false, sequenceFile, errNo);
        System.out.println(Messages.getString("WriteXML.8") + (System.currentTimeMillis() - start));
    }

    public String oerr(String typeAndNum) {
        String retVal = "";
        String baseName = "";
        String errNo = "";
        int minus = typeAndNum.indexOf(45);
        if (minus != -1) {
            baseName = typeAndNum.substring(0, minus);
            String rest = typeAndNum.substring(minus);
            if (rest.matches("^[0-9]+")) {
                int i = 0;
                for (i = 0; i < rest.length(); ++i) {
                    if (Character.isDigit(rest.charAt(i))) continue;
                    errNo = rest.substring(0, i);
                    break;
                }
                if (i == rest.length()) {
                    errNo = rest;
                }
                retVal = this.oerr(baseName, errNo);
            }
        }
        return retVal;
    }

    public String oerr(String baseName, String errNo) {
        String retVal = "";
        if (!((baseName = baseName.toLowerCase()).equals("tns") || baseName.equals("ora") || baseName.equals("dgm"))) {
            return Messages.getString("WriteXML.17");
        }
        try {
            long start = System.currentTimeMillis();
            String sequenceFile = this.getIndexFile(true, baseName, errNo);
            System.out.println(Messages.getString("WriteXML.18") + (System.currentTimeMillis() - start));
            if (sequenceFile != null && sequenceFile != "") {
                start = System.currentTimeMillis();
                retVal = this.outputMatch(true, sequenceFile, errNo);
                System.out.println(Messages.getString("WriteXML.20") + (System.currentTimeMillis() - start));
            }
        }
        catch (Exception e) {
            retVal = "";
        }
        return retVal;
    }

    private String getIndexFile(boolean byResource, String baseName, String errNo) {
        try {
            GetFile getoutput;
            BufferedInputStream in = null;
            if (!byResource) {
                URL file = new URL(this.indexDirectory + File.separator + "index.xml");
                in = new BufferedInputStream(new FileInputStream(new File(file.toURI())));
            } else {
                InputStream nobuf = this.getClass().getResourceAsStream("index.xml");
                in = new BufferedInputStream(nobuf);
            }
            if (this._factory == null) {
                this._factory = SAXParserFactory.newInstance();
                this._factory.setValidating(false);
            }
            GetFile handler = getoutput = new GetFile(baseName, errNo);
            long start = System.currentTimeMillis();
            this._factory.newSAXParser().parse((InputStream)in, (DefaultHandler)handler);
            System.out.println("do parse:" + (System.currentTimeMillis() - start));
            return getoutput.lookfor;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return "";
        }
    }

    private String outputMatch(boolean byresource, String sequenceFile, String errNo) {
        String retVal = "";
        try {
            SAXHandler getoutput;
            BufferedInputStream in = null;
            if (byresource) {
                System.out.println(sequenceFile);
                InputStream nobuf = this.getClass().getResourceAsStream(sequenceFile);
                in = new BufferedInputStream(nobuf);
            }
            if (this._factory == null) {
                this._factory = SAXParserFactory.newInstance();
                this._factory.setValidating(false);
            }
            SAXHandler handler = getoutput = new SAXHandler(errNo);
            InputSource is = new InputSource(in);
            is.setEncoding("UTF-8");
            this._factory.newSAXParser().parse(is, (DefaultHandler)handler);
            System.out.println(getoutput.lookfor.toString());
            if (getoutput.lookfor.toString() != null && !getoutput.lookfor.toString().equals("")) {
                retVal = getoutput.lookfor.toString();
            }
        }
        catch (Exception e) {
            retVal = "";
        }
        return retVal;
    }

    void setupSax(String getme) {
        try {
            SAXHandler getoutput;
            URL file = new URL("/tmp/reallyworks_");
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(new File(file.toURI())));
            if (this._factory == null) {
                this._factory = SAXParserFactory.newInstance();
            }
            this._factory.setValidating(false);
            SAXHandler handler = getoutput = new SAXHandler(getme);
            this._factory.newSAXParser().parse((InputStream)in, (DefaultHandler)handler);
            System.out.println(getoutput.lookfor.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setup() throws Exception {
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setCoalescing(true);
        this.builder = this.factory.newDocumentBuilder();
        this.document = this.builder.newDocument();
        this.root = this.document.createElement("errors");
    }

    void writeOneSequence(String numberString, String payloadString) {
        Element payload = this.sequenceDocument.createElement("payload");
        payload.setAttribute("number", numberString);
        payload.appendChild(this.sequenceDocument.createTextNode(payloadString));
        this.sequenceRoot.appendChild(payload);
    }

    void writeOne(String numberString, String payloadString) {
        Element payload = this.document.createElement("payload");
        payload.setAttribute("number", numberString);
        payload.appendChild(this.document.createTextNode(payloadString));
        this.root.appendChild(payload);
    }

    void writeOnemanyelements(String numberString, String payloadString) {
        Element cover = this.document.createElement("cover");
        Element number = this.document.createElement("number");
        number.appendChild(this.document.createTextNode(numberString));
        cover.appendChild(number);
        Element payload = this.document.createElement("payload");
        payload.appendChild(this.document.createTextNode(payloadString));
        cover.appendChild(payload);
        this.root.appendChild(cover);
    }

    void doit() {
        try {
            this.setup();
            this.writeOne("001", "Payload1");
            this.writeOne("002", "& <! Payload2 & <! ");
            this.document.appendChild(this.root);
            WriteXML.writeXmlFile(this.document, "/tmp/reallyworks_");
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            System.exit(1);
        }
    }

    void finishSequenceFile() {
        try {
            this.sequenceDocument.appendChild(this.sequenceRoot);
            WriteXML.writeXmlFile(this.sequenceDocument, this.indexDirectory + File.separator + this.localBaseName.substring(this.localBaseName.lastIndexOf(47) + 1) + this.localFileSequence + this.localLanguage + ".xml");
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            System.exit(1);
        }
    }

    void finishIndexFile() {
        try {
            this.indexDocument.appendChild(this.indexRoot);
            WriteXML.writeXmlFile(this.indexDocument, this.indexDirectory + File.separator + "index.xml");
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            System.exit(1);
        }
    }

    void finish() {
        try {
            this.document.appendChild(this.root);
            WriteXML.writeXmlFile(this.sequenceDocument, "/tmp/reallyworks_");
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            System.exit(1);
        }
    }

    public static void writeXmlFile(Document doc, String filename) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            DOMSource source = new DOMSource(doc);
            URL url = new URL(filename);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            StringWriter outWriter = new StringWriter();
            StreamResult toStream = new StreamResult(outWriter);
            transformer.transform(source, toStream);
            outWriter.close();
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(new File(url.toURI()));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            osw.write(outWriter.toString());
            osw.close();
            ((OutputStream)out).close();
        }
        catch (TransformerConfigurationException e) {
            Logger.getLogger(WriteXML.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (TransformerException e) {
            Logger.getLogger(WriteXML.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (IOException e) {
            Logger.getLogger(WriteXML.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }
}

