/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.IListPrinter;
import oracle.dbtools.raptor.utils.NLSUtils;

public class ListPrinter
implements IListPrinter {
    private boolean _forcePrintValue = false;
    private ScriptRunnerContext _ctx;

    public void forcePrintValue(boolean force) {
        this._forcePrintValue = force;
    }

    @Override
    public String getValue(Map<String, ?> m, String key) {
        if (m.get(key) == null) {
            return "";
        }
        return m.get(key).toString();
    }

    @Override
    public int getWidest(List<Map<String, ?>> cols, String string) {
        int ret = string.length();
        for (Map<String, ?> m : cols) {
            if (m.get(string) == null) continue;
            int l = m.get(string).toString().length();
            ret = l > ret ? (ret = l) : ret;
        }
        return ret;
    }

    @Override
    public void print(OutputStream outStream, Connection conn, List<List<?>> rows) throws IOException {
        this.print(outStream, conn, rows, -1);
    }

    @Override
    public void print(OutputStream outStream, Connection conn, List<List<?>> rows, int pageSize) throws IOException {
        this.print(outStream, conn, rows, pageSize, "", null);
    }

    @Override
    public void print(OutputStream outStream, Connection conn, List<List<?>> rows, int pageSize, String nullDisplay, List<Boolean> isNumber) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(outStream);
        if (rows != null && rows.size() > 0) {
            List<?> headers = rows.get(0);
            int[] widths = new int[rows.get(0).size()];
            for (List<?> row : rows) {
                for (int i = 0; i < row.size(); ++i) {
                    int colLength;
                    if (row.get(i) == null || widths[i] >= row.get(i).toString().length() + 2) continue;
                    String strRep = NLSUtils.format(conn, row.get(i));
                    int width = strRep.length() + 2;
                    if (width < (colLength = headers.get(i).toString().length())) {
                        width = colLength;
                    }
                    widths[i] = width;
                }
            }
            boolean j = false;
            rows.remove(0);
            if (rows.size() != 0) {
                int i = 0;
                for (List<?> row : rows) {
                    int ii = 0;
                    if (i == 0 && pageSize < 0 || pageSize > 0 && i % pageSize == 0) {
                        this.printHeaders(out, widths, 0, headers, isNumber);
                    }
                    for (Object col : row) {
                        String s;
                        String val = NLSUtils.format(conn, col);
                        if (val == null) {
                            String string = val = nullDisplay != null ? nullDisplay : "";
                        }
                        if (col != null && col.toString().indexOf("@|") >= 0 && col.toString().indexOf("|@") > 0 || this._forcePrintValue) {
                            try {
                                this.printValue(out, widths[ii], val, isNumber != null ? isNumber.get(ii) : false);
                            }
                            catch (IllegalArgumentException e) {
                                out.write(e.getLocalizedMessage());
                            }
                        } else if (isNumber != null && isNumber.get(ii).booleanValue() && val != null) {
                            s = String.join((CharSequence)"", Collections.nCopies(widths[ii] - val.length() + 1, " ")) + val;
                            out.write(s);
                        } else {
                            s = val + String.join((CharSequence)"", Collections.nCopies(widths[ii] - val.length() + 1, " "));
                            out.write(s);
                        }
                        out.write(" ");
                        ++ii;
                    }
                    if (pageSize != 0) {
                        out.write("\n");
                    }
                    ++i;
                }
            }
            Object mute = null;
            if (this._ctx != null) {
                mute = this._ctx.getProperty("ILISTPRINTER_MUTE_NEWLINE");
            }
            if (mute == null || !mute.equals(Boolean.TRUE)) {
                out.write("\n");
            }
        }
        out.flush();
    }

    @Override
    public void print(ScriptRunnerContext ctx, List<Map<String, ?>> rows) {
        if (rows.size() > 0) {
            int[] widths = new int[rows.get(0).size()];
            String[] colName = new String[rows.get(0).size()];
            int i = 0;
            Iterator<Object> iterator = rows.get(0).keySet().iterator();
            while (iterator.hasNext()) {
                String string;
                colName[i] = string = iterator.next();
                widths[i] = this.getWidest(rows, string) + 2;
                ++i;
            }
            i = 0;
            for (String string : rows.get(0).keySet()) {
                this.writeBoldUnderlineFormat(ctx, string, widths[i]);
                ++i;
            }
            ctx.write("\n");
            for (Map map : rows) {
                i = 0;
                for (String col : colName) {
                    ctx.write(String.format("%-" + widths[i] + "s", this.getValue(map, col)));
                    ++i;
                }
                ctx.write("\n");
            }
            ctx.write("\n");
        } else {
            ctx.write("No Data Found.");
        }
    }

    @Override
    public void printHeaders(OutputStreamWriter out, int[] widths, int j, List<?> headers, List<Boolean> isNumber) throws IOException {
        for (Object col : headers) {
            String align = "-";
            out.write(String.format("%-" + (widths[j] + 1) + "s", col.toString()));
            out.write(" ");
            ++j;
        }
        out.write("\n");
    }

    @Override
    public void printListofList(ScriptRunnerContext ctx, List<List<?>> rows) {
        try {
            this.print(ctx.getOutputStream(), ctx.getCurrentConnection(), rows);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void printListofList(ScriptRunnerContext ctx, String title, List<List<?>> rows) {
        if (title != null) {
            ctx.write(title + "\n");
        }
        this.printListofList(ctx, rows);
    }

    @Override
    public void printValue(OutputStreamWriter out, int width, String val, boolean isNumber) throws IOException {
        String s = isNumber ? String.join((CharSequence)"", Collections.nCopies(width - val.length() + 1, " ")) + val : val + String.join((CharSequence)"", Collections.nCopies(width - val.length() + 1, " "));
        out.write(s);
        out.write(" ");
    }

    @Override
    public void setScriptContext(ScriptRunnerContext ctx) {
        this._ctx = ctx;
    }

    @Override
    public void writeBoldUnderlineFormat(ScriptRunnerContext ctx, String col, int i) {
        ctx.write(String.format("%-" + i + "s", col));
        ctx.write(" ");
    }
}

