/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

import java.io.Serializable;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.query.QueryParameter;

public class Bind
extends QueryParameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DataValue _dataValue;
    private DataType _dataType;
    private String _printValue;
    private String _value;
    private Object _valueObj;
    private Boolean _lastSetObj = false;
    private String _withBracket = null;
    private Mode mode;
    private int _begin = -1;
    private int _end = -1;

    public Bind() {
    }

    public Bind(String name, String type, String typeBracket, String prompt, String value, String tooltip) {
        this.setBracket(typeBracket);
        this.init(name, type, prompt, value, tooltip, Mode.UNKNOWN);
    }

    public Bind(String name, String type, String prompt, String value, String tooltip) {
        this(name, type, prompt, value, tooltip, Mode.UNKNOWN);
    }

    public Bind(String name, String type, String prompt, String value, String tooltip, Mode mode) {
        this.setBracket(null);
        this.init(name, type, prompt, value, tooltip, mode);
    }

    public Bind(String name, DataType type, DataValue value, Mode mode) {
        this.setBracket(null);
        this.setName(name);
        this._dataType = type;
        this.setDataValue(value);
        this.mode = mode;
    }

    public void init(String name, String type, String prompt, String value, String tooltip, Mode mode) {
        this.setName(name);
        this.setType(type);
        this.setPrompt(prompt);
        this.setTooltip(tooltip);
        this.setValue(value);
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setValue(String value) {
        this._lastSetObj = false;
        this._value = value;
    }

    public String getValue() {
        return this._value;
    }

    public boolean isLastSetObj() {
        return this._lastSetObj;
    }

    public void setValueObj(Object value) {
        this._lastSetObj = true;
        this._valueObj = value;
    }

    public Object getValueObj() {
        return this._valueObj;
    }

    public DataValue getDataValue() {
        return this._dataValue;
    }

    public DataType getDataType() {
        return this._dataType;
    }

    public void setDataValue(DataValue dataValue) {
        this._lastSetObj = false;
        this._dataValue = dataValue;
    }

    public void setBracket(String value) {
        this._withBracket = value;
    }

    public String getBracket() {
        return this._withBracket;
    }

    public void setBegin(int value) {
        this._begin = value;
    }

    public int getBegin() {
        return this._begin;
    }

    public void setEnd(int value) {
        this._end = value;
    }

    public int getEnd() {
        return this._end;
    }

    public String getPrintBind() {
        if (this._printValue == null) {
            return this.getName();
        }
        return this._printValue;
    }

    public void setPrintBind(String printName) {
        this._printValue = printName;
    }

    @Override
    public String toXML(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(Bind.getIndent(indent) + "<bind id=\"" + this.getName() + "\"" + this.getBaseAttributes() + ">\n");
        sb.append(this.getBaseChildren(indent + 1));
        sb.append(Bind.getIndent(indent + 1) + "<value><![CDATA[" + this._value + "]]></value>\n");
        sb.append(Bind.getIndent(indent + 1) + "<bracket><![CDATA[" + this._withBracket + "]]></bracket>\n");
        sb.append(Bind.getIndent(indent) + "</bind>\n");
        return sb.toString();
    }

    public static enum Mode {
        IN,
        OUT,
        INOUT,
        UNKNOWN,
        RETURNING;

    }
}

