/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import oracle.dbtools.raptor.datatypes.objects.OraINTERVALDS;
import oracle.dbtools.raptor.nls.Messages;
import oracle.dbtools.raptor.nls.OraIntervalDatumFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.INTERVALDS;

public class OraINTERVALDSFormat
extends OraIntervalDatumFormat {
    public OraINTERVALDSFormat(OraLocaleInfo localeInfo) throws ParseException {
        super(localeInfo);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof OraINTERVALDSFormat && super.equals(object);
    }

    public String format(INTERVALDS date) {
        return this.format(date, new StringBuffer(), new FieldPosition(255)).toString();
    }

    public StringBuffer format(INTERVALDS interval, StringBuffer toAppendTo, FieldPosition pos) {
        if (interval != null) {
            OraINTERVALDS iVal = OraINTERVALDS.getInstance(interval);
            int sign = iVal.get(0);
            int days = iVal.get(1);
            int hours = iVal.get(2);
            int minutes = iVal.get(3);
            int seconds = iVal.get(4);
            int nanos = iVal.get(5);
            String nanoPattern = "%09d";
            if (nanos % 1000 == 0) {
                nanos /= 1000;
                nanoPattern = "%06d";
            }
            String str = (sign == -1 ? "-" : "+") + String.format("%02d", days) + " " + String.format("%02d", hours) + ":" + String.format("%02d", minutes) + ":" + String.format("%02d", seconds) + "." + String.format(nanoPattern, nanos);
            toAppendTo.append(str);
        }
        return toAppendTo;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null || obj instanceof INTERVALDS) {
            return this.format((INTERVALDS)obj, toAppendTo, pos);
        }
        throw new IllegalArgumentException(Messages.getString("OraINTERVALDSFormat.90"));
    }

    public INTERVALDS parse(String text, ParsePosition pos) {
        if (text != null && text.length() > 0) {
            byte[] bytes = INTERVALDS.toBytes((String)text.substring(pos.getIndex()));
            return new INTERVALDS(bytes);
        }
        return null;
    }
}

