/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamedItemBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parameter;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public final class TypeBuilder
extends NamedItemBuilder<TypeBuilder> {
    private String truncations;
    private List<String> abbreviations;
    private final List<Option> options = new ArrayList<Option>();
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private final List<Type> nestedTypes = new ArrayList<Type>();
    private boolean base;

    public TypeBuilder(String name) {
        super(name);
    }

    public TypeBuilder truncations(String truncations) {
        this.truncations = truncations;
        return this;
    }

    public TypeBuilder abbreviations(String ... abbreviations) {
        this.abbreviations = Arrays.asList(abbreviations);
        return this;
    }

    public <T> TypeBuilder add(Option<T> option) {
        this.options.add(option);
        return this;
    }

    public <T> TypeBuilder add(Parameter<T> parameter) {
        this.parameters.add(parameter);
        return this;
    }

    public TypeBuilder add(Type nestedType) {
        this.nestedTypes.add(nestedType);
        return this;
    }

    public TypeBuilder base() {
        this.base = true;
        return this;
    }

    public Type build() {
        return new TypeImpl(this);
    }

    private static class TypeImpl
    extends NamedItemBuilder.NamedItemImpl
    implements Type {
        private final Optional<String> truncations;
        private final List<String> abbreviations;
        private final List<Option> options;
        private final List<Parameter> parameters;
        private final List<Type> nestedTypes;
        private final boolean base;

        private TypeImpl(TypeBuilder builder) {
            super(builder);
            this.truncations = Optional.ofNullable(builder.truncations != null ? builder.truncations.toUpperCase() : null);
            this.abbreviations = builder.abbreviations != null ? Collections.unmodifiableList(builder.abbreviations.stream().map(abbrev -> abbrev.toUpperCase()).collect(Collectors.toList())) : Collections.EMPTY_LIST;
            this.options = Collections.unmodifiableList(builder.options);
            this.parameters = Collections.unmodifiableList(builder.parameters);
            this.nestedTypes = Collections.unmodifiableList(builder.nestedTypes);
            this.base = builder.base;
        }

        @Override
        public Optional<String> getTruncations() {
            return this.truncations;
        }

        @Override
        public List<String> getAbbreviations() {
            return this.abbreviations;
        }

        @Override
        public List<Option> getOptions() {
            return this.options;
        }

        @Override
        public List<Parameter> getParameters() {
            return this.parameters;
        }

        @Override
        public List<Type> getNestedTypes() {
            return this.nestedTypes;
        }

        @Override
        public boolean isBase() {
            return this.base;
        }
    }
}

