/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import oracle.dbtools.raptor.newscriptrunner.util.parser.AbstractAttributeBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;

public final class OptionBuilder
extends AbstractAttributeBuilder<OptionBuilder> {
    private String truncations;
    private List<String> abbreviations;

    public OptionBuilder(Class<?> type, String name) {
        super(type, name);
    }

    public OptionBuilder truncations(String truncations) {
        this.truncations = truncations;
        return this;
    }

    public OptionBuilder abbreviations(String ... abbreviations) {
        this.abbreviations = Arrays.asList(abbreviations);
        return this;
    }

    public <T> Option<T> build() {
        return new OptionImpl(this);
    }

    private static class OptionImpl<T>
    extends AbstractAttributeBuilder.AbstractAttributeImpl<T>
    implements Option<T> {
        private final Optional<String> truncations;
        private final List<String> abbreviations;

        private OptionImpl(OptionBuilder builder) {
            super(builder);
            this.truncations = Optional.ofNullable(builder.truncations != null ? builder.truncations.toUpperCase() : null);
            this.abbreviations = builder.abbreviations != null ? Collections.unmodifiableList(builder.abbreviations.stream().map(abbrev -> abbrev.toUpperCase()).collect(Collectors.toList())) : Collections.EMPTY_LIST;
        }

        @Override
        public boolean isFlag() {
            return this.type.equals(Boolean.class);
        }

        @Override
        public Optional<String> getTruncations() {
            return this.truncations;
        }

        @Override
        public List<String> getAbbreviations() {
            return this.abbreviations;
        }
    }
}

