/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.function.Consumer;
import java.util.function.Function;
import oracle.dbtools.raptor.newscriptrunner.util.parser.AbstractAttribute;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamedItemBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.PrimitiveTransformers;

public abstract class AbstractAttributeBuilder<B extends AbstractAttributeBuilder<B>>
extends NamedItemBuilder<B> {
    private final Class<?> type;
    private Function<String, ?> transformer;
    private boolean required;
    private Object defaultValue;

    protected AbstractAttributeBuilder(Class<?> type, String name) {
        super(name);
        this.type = type;
    }

    public B required() {
        this.required = true;
        return (B)this;
    }

    public B transformer(Function<String, ?> transformer) {
        this.transformer = transformer;
        return (B)this;
    }

    public B defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return (B)this;
    }

    static abstract class AbstractAttributeImpl<T>
    extends NamedItemBuilder.NamedItemImpl
    implements AbstractAttribute<T> {
        final Class<T> type;
        private final boolean required;
        private final Function<String, T> transformer;
        private final T defaultValue;

        AbstractAttributeImpl(AbstractAttributeBuilder<?> builder) {
            super(builder);
            if (builder.defaultValue != null && !builder.type.isAssignableFrom(builder.defaultValue.getClass())) {
                throw new IllegalArgumentException("type of defaultValue is inconsistent with the type of attribute with name " + builder.name);
            }
            this.type = builder.type;
            this.required = builder.required;
            this.defaultValue = builder.defaultValue;
            this.transformer = builder.transformer == null ? PrimitiveTransformers.get(this.type) : builder.transformer;
        }

        @Override
        public Class<T> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public T getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public T transform(String value, Consumer<String> errorConsumer) {
            T result = null;
            try {
                result = this.transformer.apply(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return result;
        }
    }
}

