/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IEndOfShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.R4)
public class ShowSpparameter
implements IShowCommand,
IEndOfShowCommand {
    private static final String[] SHOWSPPARAMETER = new String[]{"spparameter", "spparameters"};

    @Override
    public String[] getShowAliases() {
        return SHOWSPPARAMETER;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowSpparameters(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doShowSpparameters(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        block30: {
            String toLower = ScriptUtils.eatOneWord(cmd.getSql()).trim().toLowerCase();
            String userArgument = null;
            userArgument = toLower.startsWith(SHOWSPPARAMETER[1]) ? toLower.replaceAll("^" + SHOWSPPARAMETER[1], "").trim().split("\\s+")[0] : toLower.replaceAll("^" + SHOWSPPARAMETER[0], "").trim().split("\\s+")[0];
            Object argument = "%";
            if (!userArgument.equals("")) {
                argument = "%" + userArgument + "%";
            }
            boolean amILocked = false;
            boolean amIDoubleLocked = false;
            ResultSet rset = null;
            Connection curConn = ctx.getCurrentConnection();
            try {
                if (curConn != null) {
                    amILocked = LockManager.lock(curConn);
                }
                if (!amILocked) break block30;
                ctx.putProperty("sqldev.last.err.message.forsqlcode", null);
                String querySql = "SELECT  substr(SID,0,20) SID,  substr(NAME,0,50) NAME,  TYPE,  DISPLAY_VALUE VALUE FROM V$SPPARAMETER  WHERE UPPER(NAME) LIKE UPPER(:NMBIND_SHOW_OBJ)  ORDER BY NAME,VALUE";
                ArrayList<Object> localBind = new ArrayList<Object>();
                localBind.add(argument);
                rset = DBUtil.getInstance(ctx.getCurrentConnection()).executeQuery(querySql, localBind);
                if (rset != null) {
                    Integer fs;
                    ResultSetFormatter rFormat;
                    block31: {
                        rFormat = new ResultSetFormatter(ctx);
                        rFormat.setProgressUpdater(ctx.getTaskProgressUpdater());
                        fs = null;
                        try {
                            if (ctx.getProperty("script.runner.arraysize") != null) {
                                fs = Integer.valueOf((String)ctx.getProperty("script.runner.arraysize"));
                                break block31;
                            }
                            boolean doubleLocked = false;
                            Connection baseConn = ctx.getBaseConnection();
                            if (baseConn != null) {
                                doubleLocked = LockManager.lock(baseConn);
                            }
                            if (!doubleLocked) break block31;
                            try {
                                Properties props = ConnectionResolver.getConnectionInfo(ConnectionResolver.getConnectionName(baseConn));
                                fs = Integer.valueOf(props.getProperty("PreferfedFetchSize"));
                            }
                            finally {
                                LockManager.unlock(baseConn);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (fs != null) {
                        try {
                            rset.setFetchSize(fs);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    rFormat.rset2sqlplusShrinkToSize(rset, ctx.getCurrentConnection(), ctx.getOutputStream());
                    break block30;
                }
                ctx.write(Messages.getString("SHOWSPPARAMETERSNORESULTSET"));
            }
            catch (IOException e) {
                ctx.write(e.getLocalizedMessage());
            }
            catch (SQLException e) {
                ctx.putProperty("sqldev.last.err.message.forsqlcode", e.getMessage());
                ctx.write(e.getLocalizedMessage());
            }
            finally {
                if (rset != null) {
                    DBUtil.closeResultSet(rset);
                }
                if (amILocked) {
                    try {
                        LockManager.unlock(curConn);
                    }
                    catch (Exception e) {}
                }
            }
        }
        return true;
    }
}

