/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.NONE)
public class ShowScan
implements IShowCommand {
    private static final String SHOWSCAN = "scan";

    @Override
    public String[] getShowAliases() {
        return new String[]{SHOWSCAN};
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowScan(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowScan(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String message = "scan {0}\n";
        if (ctx.getScanOn()) {
            ctx.write(MessageFormat.format(message, "ON"));
        } else {
            ctx.write(MessageFormat.format(message, "OFF"));
        }
        return true;
    }
}

