/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.CommonServices;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorTypeCache;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.StandardFormConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.URLProperty;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;

public class ThirdPartyConnector
extends StandardFormConnector {
    public ThirdPartyConnector(ConnectorArgs args) {
        super(args);
    }

    @Override
    protected StandardFormConnector.ConnectionRec createConnection(List<String> urlMessage, String connectName, String connectPassword, String connectDB, String role) {
        if (connectDB == null || connectDB.equals("")) {
            connectDB = CommonServices.get(ConnectorTypeCache.class).getConnectionContext(this.ctx).getCurrentPropertyValues().getValueOf(URLProperty.URL);
        }
        Connection myconn = null;
        Object thirdURL = connectDB;
        if (connectName != null) {
            thirdURL = connectPassword != null ? "PASSWORD=" + connectPassword + "]" + (String)thirdURL : "PASSWORD=]" + (String)thirdURL;
            thirdURL = "[USERNAME=" + connectName + "," + (String)thirdURL;
        }
        ConnectionDetails cd = null;
        try {
            if (!SQLPLUSUtil.hasUrlStub(connectDB)) {
                cd = new ConnectionDetails((String)thirdURL);
                Driver driver = DriverManager.getDriver(connectDB);
                String driverClassName = driver.getClass().getName();
                if (!driverClassName.equals(cd.getDriver())) {
                    cd.setDriver(driverClassName);
                }
            }
        }
        catch (SQLException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage());
            this.ctx.write(MessageFormat.format(Messages.getString(Messages.Key.NO_DRIVER), connectDB) + "\n");
            cd = null;
        }
        if (cd != null && cd.getDriver() != null) {
            myconn = cd.getConn();
        }
        return new StandardFormConnector.ConnectionRec(myconn);
    }
}

