/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connect;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.CommonServices;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorTypeCache;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Property;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.RawPropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.SetType;

public class SetShowConnectorProperty
extends CommandListener {
    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ConnectorTypeCache cache = CommonServices.get(ConnectorTypeCache.class);
        ArrayList<String> errors = new ArrayList<String>();
        ParseInfo pi = this.parse(cache, cmd.getSql().trim(), errors::add);
        if (pi == null) {
            return false;
        }
        if (errors.isEmpty()) {
            switch (pi.commandType) {
                case SET: {
                    this.setProperty(pi.property, ctx, cache.getConnectionContext(ctx).getContextPropertyValues(), pi.rawValues, errors);
                    break;
                }
                case SHOW: {
                    this.showProperty(pi.property, false, ctx);
                }
            }
        }
        for (String error : errors) {
            ctx.write(error + "\n");
        }
        return true;
    }

    private void setProperty(Property<?> property, ScriptRunnerContext ctx, PropertyValues propertyValues, Map<String, Object> rawValuesMap, List<String> errors) {
        RawPropertyValues rawValues = RawPropertyValues.create(rawValuesMap);
        if (property.getSetType() == SetType.SETTABLE) {
            Object value = property.createValue(ctx, rawValues, errors::add);
            if (errors.isEmpty()) {
                propertyValues.setValueOf(property, value);
            }
            for (Property<?> option : property.getOptions()) {
                Object optVal = option.createValue(ctx, rawValues, errors::add);
                if (!errors.isEmpty()) continue;
                propertyValues.setValueOf(option, optVal);
            }
        }
    }

    private void showProperty(Property<?> property, boolean showName, ScriptRunnerContext ctx) {
        PropertyValues properties;
        String valueRep;
        if (property.getSetType() != SetType.NONE && !(valueRep = property.asString(properties = CommonServices.get(ConnectorTypeCache.class).getConnectionContext(ctx).getContextPropertyValues())).isEmpty()) {
            StringBuilder buff = new StringBuilder();
            buff.append(property.getName().toLowerCase()).append(": ");
            if (property.isRedacted()) {
                buff.append("***");
            } else {
                buff.append(valueRep);
            }
            for (Property<?> option : property.getOptions()) {
                String optValueRep = option.asString(properties);
                if (optValueRep.isEmpty()) continue;
                buff.append("\n").append(option.getName().toLowerCase()).append(": ");
                if (option.isRedacted()) {
                    buff.append("***");
                    continue;
                }
                buff.append(optValueRep);
            }
            if (buff.length() > 0) {
                ctx.write(buff.toString() + "\n");
            }
        }
    }

    private ParseInfo parse(ConnectorTypeCache cache, String command, Consumer<String> errorConsumer) {
        CommandType commandType;
        String[] words = command.trim().split("[ ]+");
        if (words.length < 2) {
            return null;
        }
        String commandName = words[0];
        if ("set".equalsIgnoreCase(commandName)) {
            commandType = CommandType.SET;
        } else if ("show".equalsIgnoreCase(commandName)) {
            commandType = CommandType.SHOW;
        } else {
            return null;
        }
        TreeMap<String, Object> rawValues = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        String propertyName = words[1];
        Property property = cache.getProperty(propertyName);
        if (property == null || property.getSetType() != SetType.SETTABLE) {
            return null;
        }
        switch (commandType) {
            case SET: {
                String word;
                int wordNo;
                for (wordNo = 2; wordNo < words.length && (word = words[wordNo]).startsWith("-"); ++wordNo) {
                    String name;
                    word = word.substring(1);
                    String value = null;
                    String[] parts = word.split("=");
                    if (parts.length == 2) {
                        name = parts[0];
                        value = parts[1];
                    } else {
                        name = word;
                    }
                    if (rawValues.containsKey(name)) {
                        errorConsumer.accept(MessageFormat.format(Messages.getString(Messages.Key.DUPLICATE_OPTION), name) + "\n");
                        continue;
                    }
                    if (cache.isFlagProperty(name)) {
                        rawValues.put(name, "true");
                        continue;
                    }
                    if (parts.length == 1 && wordNo + 1 < words.length) {
                        value = words[++wordNo];
                    }
                    if (value != null) {
                        rawValues.put(name, value);
                        continue;
                    }
                    errorConsumer.accept(MessageFormat.format(Messages.getString(Messages.Key.MISSING_OPTION_VALUE), name + "\n"));
                }
                String propertyValue = String.join((CharSequence)" ", Arrays.copyOfRange(words, wordNo, words.length));
                if (propertyValue == null || propertyValue.isEmpty()) break;
                rawValues.put(propertyName, propertyValue);
                break;
            }
            default: {
                if (words.length <= 2) break;
                errorConsumer.accept(MessageFormat.format(Messages.getString(Messages.Key.UNEXPECTED_VALUE), String.join((CharSequence)" ", Arrays.copyOfRange(words, 2, words.length))));
            }
        }
        return new ParseInfo(commandType, property, rawValues);
    }

    private class ParseInfo {
        CommandType commandType;
        Property<?> property;
        Map<String, Object> rawValues;

        ParseInfo(CommandType commandType, Property<?> property, Map<String, Object> rawValues) {
            this.commandType = commandType;
            this.property = property;
            this.rawValues = rawValues;
        }
    }

    private static enum CommandType {
        SET,
        SHOW;

    }
}

