/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class SetNumberwidth
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_NUMBERWIDTH;

    public SetNumberwidth() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getProperty("prop_file_string") != null) {
            String str = cmd.getSql();
            str = str.trim().replaceAll("^(?i:set\\s+nu)(?i:m|mw|mwi|mwid|mwidt|mwidth)\\s+", "").trim();
            str = str.replaceAll("['\"]", "");
            try {
                int numwidth = new Integer(str);
                if (numwidth < 2 || numwidth > 50) {
                    ctx.write(MessageFormat.format(ScriptRunnerDbArb.getString("NUMWIDTH_OUTOFRANGE") + "\n", numwidth));
                    return false;
                }
                this.setProperties(cmd, ctx, ((Integer)ctx.getProperty("script.runner.setnumwidth")).toString(), "numwidth", "script.runner.setnumwidth");
                this.writeShowMode(cmd, ctx, str);
                ctx.putProperty("script.runner.setnumwidth", new Integer(str));
            }
            catch (NumberFormatException e) {
                ctx.write(Messages.getString("INVALID_NUMWIDTH") + "\n");
            }
        }
        return true;
    }
}

