/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.ICommandHistory;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.Messages;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunner;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.SqlParserProvider;
import oracle.dbtools.util.BOMSkipper;

public class ScriptExecutor
extends Thread {
    private Reader m_rdrForParser = null;
    private Iterator<ISQLCommand> m_parser = null;
    private Connection m_conn = null;
    private ISQLCommand m_cmd = null;
    private ScriptRunner m_runner = null;
    private boolean m_interrupted = false;
    private ScriptRunnerContext m_scriptRunnerContext = null;
    private BufferedOutputStream m_out = null;
    private static final Logger LOGGER = Logger.getLogger(ScriptExecutor.class.getName());
    private URL m_baseURL = null;
    public boolean m_finished = false;
    private String m_directory = null;

    public ScriptExecutor(URL url, Connection conn, String encoding) {
        try {
            this.setConn(conn);
            this.setStmt(new BufferedReader(new InputStreamReader(url.openStream(), encoding)));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.severe(MessageFormat.format(Messages.getString("ScriptExecutor.1"), encoding, url.toString() + "\n"));
            try {
                LOGGER.severe(Messages.getString("ScriptExecutor.3") + "\n");
                this.setStmt(new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8")));
            }
            catch (Exception e1) {
                LOGGER.severe(e.getMessage());
            }
        }
        catch (IOException e) {
            LOGGER.severe(url.toString());
        }
        this.m_baseURL = url;
    }

    public ScriptExecutor(URL url, Connection conn) {
        try {
            this.setConn(conn);
            this.setStmt(url.openStream());
            this.m_baseURL = url;
        }
        catch (IOException e) {
            LOGGER.severe(url.toString());
        }
    }

    public ScriptExecutor(InputStream in, Connection conn) {
        this.setConn(conn);
        this.setStmt(in);
    }

    public ScriptExecutor(String s, Connection conn) {
        this.setConn(conn);
        this.setStmt(s);
    }

    public ScriptExecutor(Reader rdr, Connection conn) {
        this.setConn(conn);
        this.setStmt(rdr);
    }

    public ScriptExecutor(Connection conn) {
        this.setConn(conn);
    }

    public void setConn(Connection conn) {
        this.m_conn = conn;
        if (this.m_runner != null) {
            this.m_runner.setConn(this.m_conn);
        }
    }

    public Connection getConn() {
        return this.m_conn;
    }

    public void setStmt(String s) {
        this.m_rdrForParser = new StringReader(s);
        BOMSkipper.skip(this.m_rdrForParser);
    }

    public void setStmt(InputStream in) {
        this.setStmt(new InputStreamReader(in));
    }

    private void setStmt(Reader rdr) {
        this.m_rdrForParser = rdr;
        BOMSkipper.skip(this.m_rdrForParser);
    }

    @Override
    public void interrupt() {
        this.m_interrupted = true;
        if (this.m_runner != null) {
            this.m_runner.cancel();
        }
    }

    public void setInterrupted(boolean interrupted) {
        this.m_interrupted = interrupted;
    }

    public ScriptRunnerContext getScriptRunnerContext() {
        return this.m_scriptRunnerContext;
    }

    public void setScriptRunnerContext(ScriptRunnerContext context) {
        this.m_scriptRunnerContext = context;
    }

    public void setOut(BufferedOutputStream out) {
        this.m_out = out;
    }

    public void setBaseURL(URL url) {
        this.m_baseURL = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.m_scriptRunnerContext == null) {
            this.m_scriptRunnerContext = new ScriptRunnerContext();
        }
        this.m_scriptRunnerContext.setInterrupted(false);
        if (this.m_scriptRunnerContext.getTopLevel()) {
            this.m_scriptRunnerContext.setBaseConnection(this.m_conn);
            this.m_scriptRunnerContext.setCurrentConnection(this.m_conn);
        }
        if (this.m_baseURL != null) {
            this.m_scriptRunnerContext.setLastUrl(this.m_baseURL);
        }
        this.m_scriptRunnerContext.putProperty("script.runner.base.url", this.m_baseURL);
        if (this.m_out == null) {
            this.m_out = this.m_scriptRunnerContext.getOutputStream() != null ? this.m_scriptRunnerContext.getOutputStream().getMainStream() : new BufferedOutputStream(System.out);
            this.m_scriptRunnerContext.putProperty("script.runner.using.systemout", Boolean.TRUE);
        }
        try {
            this.m_parser = SqlParserProvider.getScriptParserIterator(this.getScriptRunnerContext(), this.m_rdrForParser);
            int i = 0;
            this.m_scriptRunnerContext.putProperty("sqldev.error.any.in", Boolean.FALSE);
            this.m_scriptRunnerContext.putProperty("sqldev.error", Boolean.FALSE);
            this.m_scriptRunnerContext.putProperty("script.runner.results", null);
            Boolean amICommandLineConnect = (Boolean)this.m_scriptRunnerContext.getProperty("script.runner.commandlineconnect");
            while (this.m_parser.hasNext()) {
                block38: {
                    CommandRegistry.fireBeginScriptListeners(this.m_conn, this.getScriptRunnerContext());
                    this.m_cmd = this.m_parser.next();
                    Boolean commandLineConnect = (Boolean)this.m_scriptRunnerContext.getProperty("script.runner.commandlineconnect");
                    if ((commandLineConnect == null || !commandLineConnect.booleanValue()) && this.m_scriptRunnerContext.getProperty("sqlplus.login.file") == null && this.m_scriptRunnerContext.getProperty("SQLCLI_IGNORE_FIRST_LINE") != null && this.m_scriptRunnerContext.getProperty("SQLCLI_IGNORE_FIRST_LINE").equals(true)) {
                        this.m_scriptRunnerContext.putProperty("SQLCLI_IGNORE_FIRST_LINE", false);
                        if (!this.m_parser.hasNext()) continue;
                        this.m_cmd = this.m_parser.next();
                    }
                    if (this.m_scriptRunnerContext.isCommandLine() && this.isFile(this.m_scriptRunnerContext) && !this.m_cmd.isComplete() && !this.m_parser.hasNext() && !this.m_scriptRunnerContext.getTopLevel()) {
                        if (this.m_scriptRunnerContext.getProperty("script.runner.isslashstatement") == null || !Boolean.parseBoolean(this.m_scriptRunnerContext.getProperty("script.runner.isslashstatement").toString())) {
                            this.m_finished = true;
                            this.m_scriptRunnerContext.putProperty("incomplete", this.m_cmd);
                            break;
                        }
                        if (this.m_scriptRunnerContext.getProperty("script.runner.isslashstatement") != null && Boolean.parseBoolean(this.m_scriptRunnerContext.getProperty("script.runner.isslashstatement").toString())) {
                            this.m_cmd.setExecutable(Boolean.TRUE);
                            this.m_cmd.setRunnable(Boolean.TRUE);
                        }
                    }
                    ++i;
                    try {
                        PrintWriter pw;
                        if (((Boolean)this.m_scriptRunnerContext.getProperty("sqldev.error")).booleanValue()) {
                            this.m_scriptRunnerContext.putProperty("sqldev.error.any.in", Boolean.TRUE);
                        }
                        this.m_scriptRunnerContext.putProperty("sqldev.error", Boolean.FALSE);
                        this.m_scriptRunnerContext.putProperty("sqldev.last.err.message", null);
                        if (this.m_interrupted) {
                            break;
                        }
                        this.m_scriptRunnerContext.setOutputStreamWrapper(this.m_out);
                        this.m_scriptRunnerContext.putProperty("current_cmd_count", i);
                        if (this.m_cmd.getSQLOrig().trim().equals("") && this.m_cmd.getStatementTerminator() != null && this.m_cmd.getStatementTerminator().equals(";")) {
                            this.m_cmd = this.changeToListCmd(this.m_cmd);
                        }
                        if (this.getScriptRunnerContext().getProperty("sqlcli.login.sql") == null || !this.getScriptRunnerContext().getProperty("sqlcli.login.sql").equals(true) || this.getScriptRunnerContext().getProperty("LOGIN_FILE_ON_CWD") == null || !this.m_cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_PLSQL) && !this.m_cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQL)) {
                            this.run(this.m_cmd);
                        }
                        if (this.m_scriptRunnerContext != null && ((Boolean)this.m_scriptRunnerContext.getProperty("sqldev.error")).booleanValue() && (pw = this.m_scriptRunnerContext.getErrWriter()) != null) {
                            pw.println(this.m_cmd);
                            pw.println();
                            String err = (String)this.m_scriptRunnerContext.getProperty("sqldev.last.err.message");
                            err = err.replaceAll("\n", "\nREM ");
                            pw.println(err);
                            pw.println('\n');
                        }
                        if (!this.m_scriptRunnerContext.getExited()) break block38;
                        break;
                    }
                    catch (Exception e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getStackTrace()[0].toString(), e);
                        Boolean systemOut = (Boolean)this.m_scriptRunnerContext.getProperty("script.runner.using.systemout");
                        try {
                            this.m_out.flush();
                        }
                        catch (Exception ex) {
                            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ex.getStackTrace()[0].toString(), ex);
                        }
                        if (systemOut != null && systemOut.booleanValue()) break block38;
                        try {
                            this.m_out.close();
                        }
                        catch (Exception ex) {
                            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ex.getStackTrace()[0].toString(), ex);
                        }
                    }
                }
                if (!(!this.m_scriptRunnerContext.getTopLevel() || amICommandLineConnect != null && amICommandLineConnect.booleanValue() || this.m_scriptRunnerContext.isLoginSQL())) {
                    this.saveHistoryItem(this.m_cmd);
                }
                this.m_finished = true;
                CommandRegistry.fireEndScriptListeners(this.m_conn, this.getScriptRunnerContext());
            }
        }
        finally {
            if (this.m_rdrForParser != null) {
                try {
                    this.m_rdrForParser.close();
                }
                catch (IOException i) {}
            }
        }
        if (this.m_scriptRunnerContext.getTopLevel() && this.m_scriptRunnerContext.getCloseConnection()) {
            this.m_scriptRunnerContext.writeDisconnectWarning();
        }
        if (this.m_scriptRunnerContext.getTopLevel() && this.m_scriptRunnerContext.getCloseConnection()) {
            this.m_scriptRunnerContext.closeCurrentConnection();
        }
        try {
            this.m_out.flush();
        }
        catch (IOException e) {
            if (!this.m_interrupted) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            this.m_interrupted = false;
        }
        if (this.m_scriptRunnerContext.getTopLevel()) {
            if (this.m_scriptRunnerContext.getExited()) {
                this.m_scriptRunnerContext.reInitOnExit();
            } else {
                this.m_scriptRunnerContext.reInitNoExit();
            }
        }
    }

    private ISQLCommand changeToListCmd(ISQLCommand cmd) {
        cmd.setSql("list");
        cmd.setSQLOrig("list");
        cmd.setModifiedSQL("list");
        cmd.setStmtId(SQLCommand.StmtSubType.G_S_LIST);
        cmd.setResultsType(SQLCommand.StmtResultType.G_R_NONE);
        cmd.setStmtClass(SQLCommand.StmtType.G_C_SQLPLUS);
        cmd.setExecutable(false);
        cmd.setRunnable(true);
        return cmd;
    }

    private boolean isFile(ScriptRunnerContext scriptRunnerContext) {
        return scriptRunnerContext.getProperty("script.runner.appinfo.arraylist") != null && ((ArrayList)scriptRunnerContext.getProperty("script.runner.appinfo.arraylist")).size() > 0;
    }

    private void run(ISQLCommand command) throws IOException {
        if (this.m_runner == null) {
            this.m_runner = new ScriptRunner(this.m_conn, this.m_out, this.m_scriptRunnerContext);
            this.m_runner.setDirectory(this.getDirectory());
        }
        this.m_runner.run(command);
        if (this.getScriptRunnerContext().isDbmsEnabled()) {
            int defaultEnable = 20000;
            Integer i = (Integer)this.getScriptRunnerContext().getProperty("script.runner.lastsetserveroutput");
            if (i != null && i > defaultEnable) {
                defaultEnable = i;
            }
            ScriptExecutor.enableDbmsOutput(this.getScriptRunnerContext().getCurrentConnection(), defaultEnable);
            this.getScriptRunnerContext().clearDbmsFlags();
        }
    }

    public void setDirectory(String dir) {
        this.m_directory = dir;
    }

    public String getDirectory() {
        return this.m_directory;
    }

    public static void enableDbmsOutput(Connection conn, int bufferSize) {
        String plsqlString = "BEGIN DBMS_OUTPUT.ENABLE(" + bufferSize + "); END;";
        CallableStatement stmt = null;
        try {
            if (conn == null) {
                return;
            }
            if (conn.isClosed()) {
                return;
            }
            stmt = conn.prepareCall(plsqlString);
            stmt.execute();
        }
        catch (Exception e) {
            Logger.getLogger("ScriptExecutor").log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void saveHistoryItem(ISQLCommand cmd) {
        ICommandHistory history = (ICommandHistory)this.getScriptRunnerContext().getProperty("sqlcl.ihistorycommand");
        if (history != null && !Boolean.parseBoolean(this.getScriptRunnerContext().getProperty("sqlcl.batch.nohistory").toString()) && this.getScriptRunnerContext().getTopLevel()) {
            history.saveCommand(cmd);
        }
    }
}

