/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import oracle.dbtools.raptor.newscriptrunner.CommonService;

public abstract class CommonServices {
    private static volatile CommonServices services;

    public static <T extends CommonService> T get(Class<T> cls) {
        T service = CommonServices.getServices().getService(cls);
        Objects.requireNonNull(service);
        return service;
    }

    protected CommonServices() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CommonServices(boolean reset) {
        Class<CommonService> clazz = CommonService.class;
        synchronized (CommonService.class) {
            if (services != null && !reset) {
                throw new IllegalStateException("Internal Error: unexpected second instance of CommonServices");
            }
            services = this;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected abstract <T extends CommonService> T getService(Class<T> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CommonServices getServices() {
        CommonServices lServices = services;
        if (lServices != null) return lServices;
        Class<CommonService> clazz = CommonService.class;
        synchronized (CommonService.class) {
            lServices = services;
            if (lServices != null) return lServices;
            services = lServices = new DefaultCommonServices();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return lServices;
        }
    }

    private static class DefaultCommonServices
    extends CommonServices {
        private final Map<String, CommonService> serviceMap = new HashMap<String, CommonService>();

        private DefaultCommonServices() {
            for (CommonService service : ServiceLoader.load(CommonService.class)) {
                this.serviceMap.put(service.getServiceClass().getName(), service);
            }
        }

        @Override
        protected <T extends CommonService> T getService(Class<T> cls) {
            return (T)this.serviceMap.get(cls.getName());
        }
    }
}

