/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.plsql;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingStrategy;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataTypeSQLException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.StructureType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataTypeImpl;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.metadata.ArgMetadata;
import oracle.dbtools.raptor.datatypes.metadata.MetadataLoader;
import oracle.dbtools.raptor.datatypes.oracle.plsql.PLSQLDatum;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingIndexTABLE;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.datatypes.values.CompositeValue;
import oracle.dbtools.raptor.datatypes.values.NamedDataValue;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.sql.ARRAY;
import oracle.sql.Datum;

public class PLSQL_INDEX_TABLE
extends PLSQLDatum {
    protected final DataType subType = this.getTypeComponents().iterator().next().getValue();

    protected PLSQL_INDEX_TABLE(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, PLSQL_INDEX_TABLE.expandTypeMetadata(context, typeMetadata));
    }

    protected static TypeMetadata expandTypeMetadata(DataTypeContext context, TypeMetadata typeMetadata) {
        TypeMetadata newTypeMetadata = typeMetadata;
        if (typeMetadata.getAttribute(TypeMetadata.Attribute.TYPE_COMPONENTS) == null) {
            try {
                List<NamedValue<TypeMetadata>> attributes = PLSQL_INDEX_TABLE.loadAttributes(context, typeMetadata);
                HashMap<TypeMetadata.Attribute, Object> attributeMap = new HashMap<TypeMetadata.Attribute, Object>();
                attributeMap.put(TypeMetadata.Attribute.TYPE_COMPONENTS, attributes);
                newTypeMetadata = DataTypeFactory.getTypeMetadata(typeMetadata, attributeMap);
            }
            catch (SQLException e) {
                throw new DataTypeSQLException(e);
            }
        }
        return newTypeMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<NamedValue<TypeMetadata>> loadAttributes(DataTypeContext context, TypeMetadata typeMetadata) throws SQLException {
        DataTypeConnectionProvider provider = context.getDataTypeConnectionProvider();
        LinkedList<NamedValue<TypeMetadata>> typeComponents = new LinkedList<NamedValue<TypeMetadata>>();
        Object conn = provider.lockDataTypeConnection();
        if (conn != null) {
            try {
                LinkedList<ArgMetadata> loadStack = new LinkedList<ArgMetadata>();
                String typeOwner = typeMetadata.get_type_owner();
                String typeName = typeMetadata.get_type_name();
                String typeSubName = typeMetadata.get_type_subname();
                new MetadataLoader((Connection)conn).loadPLSQLCollection(loadStack, typeOwner, typeName, typeSubName, 0);
                if (!loadStack.isEmpty()) {
                    loadStack.pop();
                    while (!loadStack.isEmpty() && ((ArgMetadata)loadStack.peek()).getIdentifier().getLevel() == 1) {
                        ArgMetadata argMetadata = (ArgMetadata)loadStack.pop();
                        TypeMetadata componentTypeMetadata = context.getDataTypeFactory().getTypeMetadata((Map)argMetadata.getValue());
                        typeComponents.add(new NamedValue<TypeMetadata>(argMetadata.getName(), componentTypeMetadata));
                    }
                }
            }
            finally {
                provider.unlockDataTypeConnection();
            }
        }
        return typeComponents;
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        StringBuilder sb = new StringBuilder();
        int len = 0;
        String subTypeSting = this.subType.getPlainDataTypeString();
        if (maxLen < 0 || sb.length() < maxLen) {
            sb.append(subTypeSting);
        }
        len += subTypeSting.length();
        if (maxLen < 0 || sb.length() < maxLen) {
            sb.append("(");
        }
        ++len;
        List<DataValue> components = this.getComponents(value);
        int i = 0;
        for (DataValue component : components) {
            if (i > 0) {
                if (maxLen < 0 || sb.length() < maxLen) {
                    sb.append(", ");
                }
                len += 2;
            }
            String componentValue = "" + component.getStringValue(connectionProvider, stringType, maxLen);
            if (maxLen < 0 || sb.length() < maxLen) {
                sb.append(componentValue);
            }
            len += componentValue.length();
            ++i;
        }
        if (maxLen < 0 || sb.length() < maxLen) {
            sb.append(")");
        }
        return new StringValue(sb.toString(), ++len);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        List dataValueArray = this.customComponents(value);
        int arraySize = ((ArrayList)dataValueArray).size();
        ArrayList<Object> objectArray = new ArrayList<Object>(arraySize);
        for (DataValue dataValue : dataValueArray) {
            objectArray.add(dataValue.getTypedValue(valueType));
        }
        if (valueType == ValueType.JDBC) {
            Object[] arrayTemplate = (Object[])Array.newInstance(this.subType.getTypedClass(valueType), arraySize);
            return objectArray.toArray(arrayTemplate);
        }
        return objectArray;
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case JDBC: {
                Object[] arrayTemplate = (Object[])Array.newInstance(this.subType.getTypedClass(valueType), 0);
                return arrayTemplate.getClass();
            }
        }
        return ArrayList.class;
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return -14;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        ArrayList<DataValue> dataValueArray = new ArrayList<DataValue>();
        try {
            if (value == null) {
                return this.customInternalValue(connectionProvider, dataValueArray);
            }
            if (value instanceof Datum[]) {
                Datum[] datumArray;
                for (Datum datum : datumArray = (Datum[])value) {
                    dataValueArray.add(this.subType.getDataValue(datum));
                }
                return dataValueArray;
            }
            if (value instanceof ARRAY) {
                ARRAY valueArray = (ARRAY)value;
                Datum[] datumArray = valueArray.getOracleArray();
                return this.customInternalValue(connectionProvider, datumArray);
            }
            if (value.getClass().isArray()) {
                int arrayLength = Array.getLength(value);
                for (int i = 0; i < arrayLength; ++i) {
                    Object arrayElement = Array.get(value, i);
                    DataValue dataValue = this.subType.getDataValue(arrayElement);
                    dataValueArray.add(dataValue);
                }
                return dataValueArray;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                Object[] values = collection.toArray(new Object[0]);
                return this.customInternalValue(connectionProvider, values);
            }
            throw new DataTypeIllegalArgumentException(this, value);
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, value);
        }
    }

    @Override
    protected Object customInternalValueFilter(DataTypeConnectionProvider connectionProvider, Object value) {
        return this.customInternalValue(connectionProvider, DataTypesUtil.isNull(value) ? null : value);
    }

    protected ArrayList<DataValue> customComponents(DataValueInternal value) {
        return (ArrayList)value.getInternalValue();
    }

    @Override
    protected DataValue customDataValue(Object object) {
        return new CompositeValue((DataTypeImpl)this, object);
    }

    @Override
    public Object startDataValue(String name, boolean isNull) {
        if (isNull) {
            return null;
        }
        return this.customInternalValue(this.getDataTypeContext().getDataTypeConnectionProvider(), null);
    }

    @Override
    public void bodyDataValue(NamedValue value, char[] ch, int start, int length) {
    }

    @Override
    public void bodyDataValue(NamedValue value, String text) {
    }

    @Override
    public void bodyDataValue(NamedValue value, DataValue dataValue) {
        ArrayList dataValueArray = (ArrayList)value.getValue();
        dataValueArray.add(NamedDataValue.getNamedDataValue(null, dataValue));
    }

    @Override
    public DataValue endDataValue(NamedValue value) {
        return this.customDataValue(value.getValue());
    }

    @Override
    public <P extends DataBinding> BindingStrategy getBind(BindContext context, P param) {
        return new CallableBindingIndexTABLE(context, param);
    }

    @Override
    protected boolean customRequiresConnection() {
        return true;
    }

    @Override
    protected boolean customSupported() {
        int typeCode;
        boolean supported = super.customSupported();
        if (supported && this.subType != null && (typeCode = this.subType.getSqlDataType(ValueType.JDBC)) == -333) {
            supported = false;
        }
        return supported;
    }

    @Override
    public StructureType getStructureType() {
        return StructureType.TABLE;
    }
}

