/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.datatypes.objects.OraTimeZoneUtil;
import oracle.dbtools.raptor.nls.OraConversions;

class OraTemporalUtil {
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final ZoneId UTC_ID;
    public static final ZoneId DEFAULT_LTZ_ZONE_ID;
    public static final int MAX_FRACTIONAL_SECOND_PRECISION = 9;
    private static final int REGION_ID_BIT = 128;
    private static final byte OFFSET_HOUR = 20;
    private static final byte OFFSET_MINUTE = 60;
    private static final String[] DIGIT;
    private static final byte[] EPOC_BYTES;

    OraTemporalUtil() {
    }

    public static TimeZone getSessionTimeZone(String zone) {
        if (zone == null) {
            return OraTemporalUtil.defaultSessionTimeZone();
        }
        if ("UTC".equals(zone)) {
            return UTC;
        }
        return TimeZone.getTimeZone(zone);
    }

    public static TimeZone getSessionTimeZone(ZoneId zone) {
        if (zone == null) {
            return OraTemporalUtil.defaultSessionTimeZone();
        }
        if (zone == UTC_ID) {
            return UTC;
        }
        return TimeZone.getTimeZone(zone);
    }

    public static ZoneId getSessionZone(ZoneId zone) {
        if (zone == null) {
            return OraTemporalUtil.defaultSessionTimeZone().toZoneId();
        }
        return zone;
    }

    public static TimeZone defaultSessionTimeZone() {
        return TimeZone.getDefault();
    }

    private static TimeZone getResolvingTimeZone(ZoneId zone, int datumArraySize) {
        if (zone == UTC_ID || datumArraySize == 13) {
            return UTC;
        }
        if (zone != null) {
            return TimeZone.getTimeZone(zone);
        }
        return OraTemporalUtil.defaultSessionTimeZone();
    }

    public static byte[] getDatumBytes(int datumByteLength) {
        if (datumByteLength != 7 && datumByteLength != 11 && datumByteLength != 13) {
            throw new IllegalArgumentException();
        }
        byte[] bytes = new byte[datumByteLength];
        System.arraycopy(bytes, 0, EPOC_BYTES, 0, bytes.length);
        return bytes;
    }

    public static void packDatumBytes(byte[] bytes, Instant instant, int fractionalSecondPrecision) {
        OraTemporalUtil.packDatumBytes(bytes, instant, fractionalSecondPrecision, null);
    }

    public static void packDatumBytes(byte[] bytes, Instant instant, int fractionalSecondPrecision, ZoneId zone) {
        Instant roundedInstant = OraTemporalUtil.round(instant, bytes.length > 7 ? fractionalSecondPrecision : 0);
        TimeZone datumTimeZone = OraTemporalUtil.getResolvingTimeZone(zone, bytes.length);
        long epochMilli = roundedInstant.toEpochMilli();
        GregorianCalendar cal = new GregorianCalendar(datumTimeZone);
        cal.setTimeInMillis(epochMilli);
        OraTemporalUtil.packDatumBytes(bytes, cal, instant.getNano(), zone);
    }

    public static void packDatumBytes(byte[] bytes, Calendar cal, int nano, ZoneId zone) {
        OraTemporalUtil.packLocalDatumBytes(bytes, cal, nano);
        if (bytes.length == 13) {
            OraTemporalUtil.packTimeZoneID(bytes, OraTemporalUtil.getSessionZone(zone), cal.getTimeInMillis());
        }
    }

    public static void packLocalDatumBytes(byte[] bytes, Calendar cal, int nano) {
        int era = cal.get(0);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int dayOfMonth = cal.get(5);
        int hourOfDay = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        OraTemporalUtil.packYear(bytes, era == 0 ? year * -1 : year);
        bytes[2] = (byte)month;
        bytes[3] = (byte)dayOfMonth;
        bytes[4] = (byte)(hourOfDay + 1);
        bytes[5] = (byte)(minute + 1);
        bytes[6] = (byte)(second + 1);
        if (bytes.length > 7) {
            OraTemporalUtil.packNano(bytes, nano);
        }
    }

    public static void packLocalDatumBytes(byte[] bytes, LocalDateTime ldt) {
        OraTemporalUtil.packYear(bytes, ldt.getYear());
        bytes[2] = (byte)ldt.getMonthValue();
        bytes[3] = (byte)ldt.getDayOfMonth();
        bytes[4] = (byte)(ldt.getHour() + 1);
        bytes[5] = (byte)(ldt.getMinute() + 1);
        bytes[6] = (byte)(ldt.getSecond() + 1);
        if (bytes.length > 7) {
            OraTemporalUtil.packNano(bytes, ldt.getNano());
        }
    }

    public static ZonedDateTime unpackDatumBytes(byte[] bytes, int fractionalSecondPrecision) {
        return OraTemporalUtil.unpackDatumBytes(bytes, fractionalSecondPrecision, null);
    }

    public static ZonedDateTime unpackDatumBytes(byte[] bytes, int fractionalSecondPrecision, ZoneId zone) {
        GregorianCalendar cal = new GregorianCalendar(OraTemporalUtil.getResolvingTimeZone(zone, bytes.length));
        Instant instant = OraTemporalUtil.unpackDatumBytes(bytes, cal, fractionalSecondPrecision);
        return ZonedDateTime.ofInstant(instant, cal.getTimeZone().toZoneId());
    }

    public static Instant unpackDatumBytes(byte[] bytes, GregorianCalendar cal, int fractionalSecondPrecision) {
        Instant instant;
        int nano = OraTemporalUtil.unpackLocalDatumBytes(bytes, cal, fractionalSecondPrecision);
        if (bytes.length == 13) {
            String tzID = OraTemporalUtil.unpackTimeZoneID(bytes);
            TimeZone tz = OraTemporalUtil.getSessionTimeZone(tzID);
            OraTemporalUtil.recompute(cal);
            cal.setTimeZone(tz);
        }
        if (nano != (instant = cal.toInstant()).getNano()) {
            instant = Instant.ofEpochSecond(instant.getEpochSecond(), nano);
        }
        return instant;
    }

    public static int unpackLocalDatumBytes(byte[] bytes, GregorianCalendar cal, int fractionalSecondPrecision) {
        int nano;
        if (bytes.length == 13 && !cal.getTimeZone().equals(UTC)) {
            cal.setTimeZone(UTC);
        }
        if ((nano = OraTemporalUtil.unpackLocalDatumBytes(bytes, cal)) != 0 && fractionalSecondPrecision < 9) {
            BigDecimal decimalSecs = OraTemporalUtil.round(nano, fractionalSecondPrecision);
            nano = OraTemporalUtil.nano(decimalSecs);
            cal.set(14, nano / 1000000);
            int secondsAdjustment = OraTemporalUtil.seconds(decimalSecs);
            if (secondsAdjustment != 0) {
                cal.add(13, secondsAdjustment);
            }
        }
        return nano;
    }

    public static int unpackLocalDatumBytes(byte[] bytes, GregorianCalendar cal) {
        int year = OraTemporalUtil.unpackYear(bytes);
        byte month = bytes[2];
        byte dayOfMonth = bytes[3];
        int hourOfDay = bytes[4] - 1;
        int minute = bytes[5] - 1;
        int second = bytes[6] - 1;
        int nano = bytes.length > 7 ? OraTemporalUtil.unpackNano(bytes) : 0;
        cal.set(0, year < 0 ? 0 : 1);
        cal.set(1, Math.abs(year));
        cal.set(2, month - 1);
        cal.set(5, dayOfMonth);
        cal.set(11, hourOfDay);
        cal.set(12, minute);
        cal.set(13, second);
        if (nano != 0) {
            BigDecimal decimalSecs = OraTemporalUtil.round(nano, 9);
            nano = OraTemporalUtil.nano(decimalSecs);
            cal.set(14, nano / 1000000);
            int secondsAdjustment = OraTemporalUtil.seconds(decimalSecs);
            if (secondsAdjustment != 0) {
                cal.add(13, secondsAdjustment);
            }
        } else {
            cal.set(14, 0);
        }
        return nano;
    }

    public static int unpackYear(byte[] bytes) {
        return ((bytes[0] & 0xFF) - 100) * 100 + ((bytes[1] & 0xFF) - 100);
    }

    public static void packYear(byte[] bytes, int year) {
        bytes[0] = (byte)(year / 100 + 100);
        bytes[1] = (byte)(year % 100 + 100);
    }

    public static int unpackNano(byte[] bytes) {
        if (bytes.length > 7) {
            return ((bytes[7] & 0xFF) << 24) + ((bytes[8] & 0xFF) << 16) + ((bytes[9] & 0xFF) << 8) + (bytes[10] & 0xFF);
        }
        return 0;
    }

    public static void packNano(byte[] bytes, int nano) {
        bytes[7] = (byte)(nano >> 24 & 0xFF);
        bytes[8] = (byte)(nano >> 16 & 0xFF);
        bytes[9] = (byte)(nano >> 8 & 0xFF);
        bytes[10] = (byte)(nano & 0xFF);
    }

    public static boolean isTZRegionID(byte[] bytes) {
        return (bytes[11] & 0x80) != 0;
    }

    public static boolean isTZOffset(byte[] bytes) {
        return !OraTemporalUtil.isTZRegionID(bytes);
    }

    public static String unpackTimeZoneID(byte[] bytes) {
        if (bytes.length < 13) {
            return null;
        }
        if (OraTemporalUtil.isTZRegionID(bytes)) {
            int regID = OraTemporalUtil.unpackTZRegionID(bytes);
            return OraTimeZoneUtil.getInstance().getRegion(regID);
        }
        int offsetInMillis = OraTemporalUtil.unpackTZOffset(bytes);
        int offsetInMinutes = offsetInMillis / 60000;
        boolean negative = offsetInMinutes < 0;
        offsetInMinutes = Math.abs(offsetInMinutes);
        int hours = offsetInMinutes / 60;
        int minutes = offsetInMinutes % 60;
        return "GMT" + (negative ? "-" : "+") + DIGIT[hours / 10] + DIGIT[hours % 10] + ":" + DIGIT[minutes / 10] + DIGIT[minutes % 10];
    }

    public static int unpackTZRegionID(byte[] bytes) {
        return ((bytes[11] & 0x7F) << 6) + ((bytes[12] & 0xFC) >> 2);
    }

    public static int unpackTZOffset(byte[] bytes) {
        int hours = bytes[11] - 20;
        int minutes = bytes[12] - 60;
        return hours * 3600000 + minutes * 60000;
    }

    public static void packTimeZoneID(byte[] bytes, ZoneId zone) {
        OraTemporalUtil.packTimeZoneID(bytes, zone, null);
    }

    public static void packTimeZoneID(byte[] bytes, ZoneId zone, Long onDate) {
        TimeZone tz = OraTemporalUtil.getSessionTimeZone(zone);
        int regID = OraTimeZoneUtil.getInstance().getID(tz.getID());
        if (regID > 0) {
            OraTemporalUtil.packTZRegion(bytes, regID);
        } else {
            OraTemporalUtil.packTZOffset(bytes, tz, onDate);
        }
    }

    public static boolean packTZRegion(byte[] bytes) {
        return OraTemporalUtil.packTZRegion(bytes, (ZoneId)null);
    }

    public static boolean packTZRegion(byte[] bytes, ZoneId zone) {
        return OraTemporalUtil.packTZRegion(bytes, OraTemporalUtil.getSessionTimeZone(zone));
    }

    public static boolean packTZRegion(byte[] bytes, TimeZone timezone) {
        int regID = OraTimeZoneUtil.getInstance().getID(timezone.getID());
        if (regID > 0) {
            OraTemporalUtil.packTZRegion(bytes, regID);
            return true;
        }
        return false;
    }

    public static void packTZRegion(byte[] bytes, int regionID) {
        bytes[11] = (byte)((regionID & 0x1FC0) >> 6 | 0x80);
        bytes[12] = (byte)((regionID & 0x3F) << 2);
    }

    public static void packTZOffset(byte[] bytes) {
        OraTemporalUtil.packTZOffset(bytes, (ZoneId)null);
    }

    public static void packTZOffset(byte[] bytes, ZoneId zone) {
        OraTemporalUtil.packTZOffset(bytes, zone, null);
    }

    public static void packTZOffset(byte[] bytes, ZoneId zone, Long time) {
        OraTemporalUtil.packTZOffset(bytes, OraTemporalUtil.getSessionTimeZone(zone), time);
    }

    public static void packTZOffset(byte[] bytes, TimeZone timezone) {
        OraTemporalUtil.packTZOffset(bytes, timezone, null);
    }

    public static void packTZOffset(byte[] bytes, TimeZone timezone, Long time) {
        if (time == null) {
            GregorianCalendar cal = new GregorianCalendar(UTC);
            OraTemporalUtil.unpackLocalDatumBytes(bytes, cal);
            time = cal.getTimeInMillis();
        }
        OraTemporalUtil.packTZOffset(bytes, timezone.getOffset(time));
    }

    public static void packTZOffset(byte[] bytes, int offsetInMillis) {
        int offsetInMinutes = offsetInMillis / 60000;
        bytes[11] = (byte)(offsetInMinutes / 60 + 20);
        bytes[12] = (byte)(offsetInMinutes % 60 + 60);
    }

    public static BigDecimal round(int nano, int fractionSecondPrecision) {
        BigDecimal bd = new BigDecimal(nano);
        bd = bd.movePointLeft(9);
        bd = bd.setScale(fractionSecondPrecision, RoundingMode.CEILING);
        return bd;
    }

    public static Instant round(Instant instant, int fractionSecondPrecision) {
        int nanoOfSecond = instant.getNano();
        if (fractionSecondPrecision < 9 && nanoOfSecond != 0) {
            BigDecimal decimalSecs = OraTemporalUtil.round(nanoOfSecond, fractionSecondPrecision);
            int secondsAdjustment = OraTemporalUtil.seconds(decimalSecs);
            int newNanoOfSecond = OraTemporalUtil.nano(decimalSecs);
            if (secondsAdjustment != 0 || nanoOfSecond != newNanoOfSecond) {
                return Instant.ofEpochSecond(instant.getEpochSecond() + (long)secondsAdjustment, newNanoOfSecond);
            }
        }
        return instant;
    }

    public static int seconds(BigDecimal decimalSecs) {
        return decimalSecs.intValue();
    }

    public static int nano(BigDecimal decimalSecs) {
        return decimalSecs.remainder(BigDecimal.ONE).movePointRight(9).intValue();
    }

    public static boolean fits(byte[] bytes, int fractionalSecondPrecision) {
        if (fractionalSecondPrecision >= 9 || bytes.length == 7) {
            return true;
        }
        int nano = OraTemporalUtil.unpackNano(bytes);
        if (nano == 0) {
            return true;
        }
        BigDecimal decimalSecs = OraTemporalUtil.round(nano, fractionalSecondPrecision);
        return OraTemporalUtil.seconds(decimalSecs) == 0 && OraTemporalUtil.nano(decimalSecs) == nano;
    }

    public static LocalDateTime truncate(LocalDateTime ldt, OraTemporalDatum.Precision precision) {
        ChronoUnit tu;
        switch (precision) {
            case DATE: {
                if (ldt.getHour() != 0) {
                    tu = ChronoUnit.DAYS;
                    break;
                }
                if (ldt.getMinute() != 0) {
                    tu = ChronoUnit.HOURS;
                    break;
                }
            }
            case MINUTE: {
                if (ldt.getSecond() != 0) {
                    tu = ChronoUnit.MINUTES;
                    break;
                }
            }
            case SECOND: {
                if (ldt.getNano() != 0) {
                    tu = ChronoUnit.SECONDS;
                    break;
                }
            }
            case MILLISECOND: {
                if (ldt.getNano() % 1000000 != 0) {
                    tu = ChronoUnit.MILLIS;
                    break;
                }
            }
            case MICROSECOND: {
                if (ldt.getNano() % 1000 != 0) {
                    tu = ChronoUnit.MICROS;
                    break;
                }
            }
            default: {
                tu = null;
            }
        }
        LocalDateTime newLDT = tu != null ? ldt.truncatedTo(tu) : ldt;
        return newLDT;
    }

    public static Instant truncate(Calendar cal, Instant instant, OraTemporalDatum.Precision precision) {
        int fractionSecondPrecision = 0;
        switch (precision) {
            case DATE: {
                cal.set(11, 0);
                cal.set(12, 0);
            }
            case MINUTE: {
                cal.set(13, 0);
            }
            case SECOND: {
                cal.set(14, 0);
                break;
            }
            case MILLISECOND: {
                fractionSecondPrecision = 3;
                break;
            }
            case MICROSECOND: {
                fractionSecondPrecision = 6;
                break;
            }
            default: {
                if (instant == null) break;
                return instant;
            }
        }
        Instant truncatedInstant = fractionSecondPrecision > 0 ? OraTemporalUtil.round(instant, fractionSecondPrecision) : cal.toInstant();
        if (truncatedInstant.equals(instant)) {
            return instant;
        }
        return truncatedInstant;
    }

    public static final ZonedDateTime withZoneSameLocal(Calendar cal, Instant instant, ZoneId zone) {
        Instant newInstant = instant;
        TimeZone timezone = TimeZone.getTimeZone(zone);
        if (!timezone.equals(cal.getTimeZone())) {
            int era = cal.get(0);
            int year = cal.get(1);
            int month = cal.get(2);
            int dayOfMonth = cal.get(5);
            int hourOfDay = cal.get(11);
            int minute = cal.get(12);
            int second = cal.get(13);
            int millisecond = cal.get(14);
            cal.setTimeZone(timezone);
            cal.set(0, era);
            cal.set(1, year);
            cal.set(2, month);
            cal.set(5, dayOfMonth);
            cal.set(11, hourOfDay);
            cal.set(12, minute);
            cal.set(13, second);
            cal.set(14, millisecond);
            newInstant = cal.toInstant();
            if (newInstant.getNano() != instant.getNano()) {
                newInstant = Instant.ofEpochSecond(newInstant.getEpochSecond(), instant.getNano());
            }
        }
        return ZonedDateTime.ofInstant(newInstant, zone);
    }

    public static final Instant withZoneSameInstant(Calendar cal, Instant instant, ZoneId zone) {
        TimeZone timezone = TimeZone.getTimeZone(zone);
        cal.setTimeInMillis(instant.toEpochMilli());
        OraTemporalUtil.recompute(cal);
        if (!timezone.equals(cal.getTimeZone())) {
            cal.setTimeZone(timezone);
            OraTemporalUtil.recompute(cal);
        }
        return instant;
    }

    public static void copy(byte[] bytes, byte[] src) {
        OraTemporalUtil.copy(bytes, src, null, null);
    }

    public static void copy(byte[] bytes, byte[] src, ZoneId zone) {
        OraTemporalUtil.copy(bytes, src, null, zone);
    }

    public static void copy(byte[] bytes, byte[] src, Integer nano, ZoneId zone) {
        System.arraycopy(src, 0, bytes, 0, Math.min(bytes.length, src.length));
        if (bytes.length > 7) {
            if (nano != null) {
                OraConversions.checkNanosRange(nano);
                OraTemporalUtil.packNano(bytes, nano);
            } else if (src.length == 7) {
                OraTemporalUtil.packNano(bytes, 0);
            }
        }
        if (bytes.length == 13 && (src.length != 13 || zone != null)) {
            OraTemporalUtil.packTimeZoneID(bytes, zone);
        }
    }

    public static byte[] compact(byte[] bytes) {
        if (bytes.length == 11 && OraTemporalUtil.unpackNano(bytes) == 0) {
            byte[] dateBytes = OraTemporalUtil.getDatumBytes(7);
            System.arraycopy(bytes, 0, dateBytes, 0, dateBytes.length);
            return dateBytes;
        }
        return bytes;
    }

    public static byte[] expand(byte[] bytes) {
        if (bytes.length == 7) {
            byte[] tsBytes = OraTemporalUtil.getDatumBytes(11);
            System.arraycopy(bytes, 0, tsBytes, 0, bytes.length);
            OraTemporalUtil.packNano(tsBytes, 0);
            return tsBytes;
        }
        return bytes;
    }

    private static final Calendar recompute(Calendar cal) {
        cal.get(11);
        return cal;
    }

    static {
        DEFAULT_LTZ_ZONE_ID = UTC_ID = UTC.toZoneId();
        DIGIT = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        EPOC_BYTES = new byte[]{119, -86, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0};
    }
}

