/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.TimeZone;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalUtil;

public abstract class OraResolvableDatum
extends OraTemporalDatum {
    protected OraResolvableDatum(OraResolvableDatumImpl impl) {
        super(impl);
    }

    @Override
    protected OraResolvableDatumImpl getImpl() {
        return (OraResolvableDatumImpl)super.getImpl();
    }

    @Override
    public OraResolvableDatum setSessionTimeZone(TimeZone sessionTimeZone) {
        super.setSessionTimeZone(sessionTimeZone);
        return this;
    }

    @Override
    public OraResolvableDatum setSessionZone(ZoneId zone) {
        super.setSessionZone(zone);
        return this;
    }

    public static enum Realization {
        LOCAL,
        LOCAL_INSTANT,
        INSTANT,
        LTZ_INSTANT;


        public Realization getEffectiveRealization() {
            switch (this) {
                case LOCAL_INSTANT: {
                    return LOCAL;
                }
                case LTZ_INSTANT: {
                    return INSTANT;
                }
            }
            return this;
        }

        public OraTemporalDatum.Resolution getResolution() {
            switch (this.getEffectiveRealization()) {
                case LOCAL: {
                    return OraTemporalDatum.Resolution.LOCAL;
                }
            }
            return OraTemporalDatum.Resolution.INSTANT;
        }
    }

    protected static abstract class OraResolvableDatumImpl
    extends OraTemporalDatum.OraTemporalDatumImpl {
        private transient Realization realization;

        protected static ZoneId getDefaultRealizedZone(Realization realization) {
            switch (realization) {
                case LOCAL: {
                    return OraTemporalDatum.UTC_ID;
                }
            }
            return OraTemporalDatum.getDefaultDatumZone();
        }

        protected OraResolvableDatumImpl(Instant instant, Realization realization) {
            super(instant, OraResolvableDatumImpl.getDefaultRealizedZone(realization));
            this.realization = realization;
        }

        protected OraResolvableDatumImpl(LocalDateTime ldt, Realization realization) {
            super(ldt, OraResolvableDatumImpl.getDefaultRealizedZone(realization));
            this.realization = realization;
        }

        @Override
        public OraTemporalDatum.Change today() {
            OraTemporalDatum.Change change = this.getRealization() == Realization.LOCAL ? this.with(ZonedDateTime.now(OraTemporalDatum.getDefaultDatumZone(this.getSessionZone())).toLocalDate()) : super.today();
            return change;
        }

        @Override
        public OraTemporalDatum.Change now() {
            OraTemporalDatum.Change change = this.getRealization() == Realization.LOCAL ? this.with(ZonedDateTime.now(OraTemporalDatum.getDefaultDatumZone(this.getSessionZone())).toLocalDateTime()) : super.now();
            return change;
        }

        @Override
        public ZonedDateTime getSessionZonedDateTime() {
            if (this.getRealization() == Realization.LOCAL) {
                return OraTemporalUtil.withZoneSameLocal(this.getCalendar(), this.toInstant(), OraTemporalDatum.getDefaultDatumZone(this.getSessionZone()));
            }
            return super.getSessionZonedDateTime();
        }

        @Override
        public OraTemporalDatum.Resolution getResolution() {
            if (this.sessionZoneAdjusted()) {
                return OraTemporalDatum.Resolution.ZONED;
            }
            return this.getRealization().getResolution();
        }

        @Override
        public boolean sessionZoneAdjusted() {
            return this.getRealization() != Realization.LOCAL && this.getSessionZone() != null;
        }

        protected final void setRealization(Realization realization) {
            this.realization = realization;
        }

        protected final Realization getRealization() {
            return this.realization;
        }

        @Override
        public boolean userTimeZoneSupported() {
            return false;
        }

        @Override
        public boolean localSupported() {
            return true;
        }

        @Override
        public OraTemporalDatum.Change setSessionZone(ZoneId sessionZone) {
            OraTemporalDatum.Change change;
            ZoneId zone = sessionZone != null ? sessionZone : OraResolvableDatumImpl.getDefaultRealizedZone(this.getRealization());
            switch (this.getRealization()) {
                case LOCAL: {
                    change = OraTemporalDatum.Change.NONE;
                    break;
                }
                case LOCAL_INSTANT: {
                    change = this.withZoneSameLocal(zone);
                    break;
                }
                default: {
                    change = this.withZoneSameInstant(zone);
                }
            }
            super.setSessionZone(sessionZone);
            return change;
        }

        @Override
        public OraTemporalDatum.Change replicate(OraTemporalDatum.OraTemporalDatumImpl src) {
            OraTemporalDatum.Change setChange;
            this.realization = Realization.INSTANT;
            OraTemporalDatum.Change superChange = super.replicate(src);
            if (src instanceof OraResolvableDatumImpl) {
                OraResolvableDatumImpl other = (OraResolvableDatumImpl)src;
                setChange = this.setZonedDateTime(other.getZonedDateTime());
                this.realization = other.realization;
            } else {
                setChange = this.setZonedDateTime(ZonedDateTime.ofInstant(src.toSessionInstant(), OraTemporalDatum.getDefaultDatumZone(this.getSessionZone())));
            }
            return OraTemporalDatum.Change.combine(superChange, setChange);
        }

        @Override
        public OraTemporalDatum.Change setValue(OraTemporalDatum.OraTemporalDatumImpl src) {
            OraTemporalDatum.Change change;
            OraTemporalDatum.Resolution tgtRes = this.getResolution();
            OraTemporalDatum.Resolution srcRes = src.getResolution();
            block0 : switch (tgtRes) {
                case ZONED: 
                case INSTANT: {
                    switch (srcRes) {
                        case ZONED: 
                        case INSTANT: {
                            change = this.with(src.toInstant());
                            break block0;
                        }
                    }
                    change = this.with(src.toSessionInstant());
                    break;
                }
                default: {
                    change = this.setZonedDateTime(OraTemporalUtil.withZoneSameLocal(src.getCalendar(), src.toInstant(), this.getZone()));
                }
            }
            return change;
        }

        @Override
        public Object clone() {
            OraResolvableDatumImpl other = (OraResolvableDatumImpl)super.clone();
            other.realization = this.realization;
            return other;
        }
    }
}

