/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask.utils;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.ISchedulingRule;
import oracle.dbtools.raptor.backgroundTask.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.internal.ConnectionMutexFactory;
import oracle.dbtools.raptor.utils.MessageLogging;
import oracle.dbtools.util.Debug;
import oracle.dbtools.util.Logger;

public abstract class DatabaseQueryTask<V>
extends RaptorTask<V> {
    private static String MSG = "{0} locked at completion of {1} (statement = {2})";
    ISchedulingRule _rule = null;
    boolean _hasRule = true;
    boolean _isLockedBeforePause = false;

    public DatabaseQueryTask(String name, IRaptorTaskRunMode mode, boolean isPausable, boolean isCancellable) {
        this(name, mode, isPausable, isCancellable, true);
    }

    public DatabaseQueryTask(String name, IRaptorTaskRunMode mode, boolean isPausable, boolean isCancellable, boolean isIndeterminate) {
        super(name, isIndeterminate, mode);
        this.setMessage(MessageFormat.format(Messages.getString("IRaptorTaskStatus.7"), this.getQuery()));
        this.setPausable(isPausable);
        this.setCancellable(isCancellable);
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        if (this._hasRule) {
            if (this._rule == null) {
                this._rule = ConnectionMutexFactory.getRule(this.getConnectionName());
            }
            return this._rule;
        }
        return null;
    }

    @Override
    protected boolean mayInterrupt() {
        return false;
    }

    public abstract String getConnectionName();

    public Connection getConnection() {
        Connection conn = null;
        try {
            conn = ConnectionResolver.getConnection(this.getConnectionName());
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), e);
        }
        return conn;
    }

    public abstract String getQuery();

    @Override
    protected void pause() {
        this.releaseSchedulingRule();
        super.pause();
        this.acquireSchedulingRule();
    }

    protected void releaseSchedulingRule() {
        this._hasRule = false;
        try {
            this._isLockedBeforePause = LockManager.checkLock(this.getConnection());
            if (this._isLockedBeforePause) {
                LockManager.unlock(this.getConnection());
            }
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), e);
        }
    }

    protected void acquireSchedulingRule() {
        this._hasRule = true;
        if (this._isLockedBeforePause && LockManager.checkLock(this.getConnection())) {
            LockManager.lock(this.getConnection());
        }
    }

    @Override
    protected void tearDown() {
        String connectionName = this.getConnectionName();
        Connection connection = null;
        if (connectionName != null) {
            try {
                connection = ConnectionResolver.getConnection(connectionName, false);
            }
            catch (Exception e) {
                Logger.warn(this.getClass(), e);
            }
        }
        if (connection != null) {
            if (Debug.DEBUG && LockManager.checkLock(connection)) {
                Object[] msgArgs = new Object[]{this.getConnectionName(), this.getClass().getName(), this.getQuery()};
                String msg = MessageFormat.format(MSG, msgArgs);
                Logger.severe(DatabaseQueryTask.class, msg);
                MessageLogging.getInstance().reportAPIException(msg, new ExpiredConnectionLockException(), "Connections.unlock()");
            }
            while (LockManager.checkLock(connection)) {
                LockManager.unlock(connection);
            }
        }
    }

    private static class ExpiredConnectionLockException
    extends Exception {
        private ExpiredConnectionLockException() {
        }
    }
}

