/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.Icon;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.ui.IImageRegistry;

public class RaptorTaskDescriptor {
    private String _name;
    private String _message;
    private long _startTime;
    private long _lastProgressTime;
    private long _elapseTime = -1L;
    private int _progress;
    private IRaptorTaskStatus _status;
    private IRaptorTaskRunMode _runMode = IRaptorTaskRunMode.MODAL_OPTIONAL;
    private List<IRaptorTaskListener> _listenerList;
    private boolean _isInDeterminate = true;
    private Throwable _throwable;
    private boolean m_isCancelled;
    ReentrantLock _listenerLock = new ReentrantLock();
    static boolean DEBUG_TASK_STATES = false;

    public RaptorTaskDescriptor(String taskName) {
        this._name = taskName;
        this.setStatus(IRaptorTaskStatus.NEW);
        this._listenerList = new ArrayList<IRaptorTaskListener>();
    }

    public RaptorTaskDescriptor(String taskName, boolean flagInDeterminate) {
        this(taskName);
        this._isInDeterminate = flagInDeterminate;
    }

    public RaptorTaskDescriptor(String taskName, boolean flagInDeterminate, IRaptorTaskRunMode mode) {
        this(taskName, flagInDeterminate);
        this._runMode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IRaptorTaskListener listener) {
        List<IRaptorTaskListener> list = this._listenerList;
        synchronized (list) {
            this._listenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllListeners() {
        List<IRaptorTaskListener> list = this._listenerList;
        synchronized (list) {
            this._listenerList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IRaptorTaskListener listener) {
        List<IRaptorTaskListener> list = this._listenerList;
        synchronized (list) {
            this._listenerList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListener(PROPERTY field, Object oldVal) {
        if (this._startTime > 0L && !(oldVal instanceof IRaptorTaskStatus) && this._status != IRaptorTaskStatus.FINISHED && this._status != IRaptorTaskStatus.FAILED) {
            this._lastProgressTime = System.currentTimeMillis();
        }
        if (this._listenerList == null) {
            return;
        }
        try {
            this._listenerLock.lock();
            List<IRaptorTaskListener> list = this._listenerList;
            synchronized (list) {
                RaptorTaskEvent raptorTaskEvent = new RaptorTaskEvent(this, System.currentTimeMillis());
                raptorTaskEvent.setChangedProperty(field, oldVal);
                raptorTaskEvent.setThrowable(this._throwable);
                block16: for (IRaptorTaskListener listener : this._listenerList) {
                    switch (field) {
                        case STATUS: {
                            listener.stateChanged(raptorTaskEvent);
                            continue block16;
                        }
                        case MESSAGE: {
                            listener.messageChanged(raptorTaskEvent);
                            continue block16;
                        }
                        case PROGRESS: {
                            listener.progressChanged(raptorTaskEvent);
                            continue block16;
                        }
                    }
                    throw new IllegalStateException(Messages.getString("RaptorTaskDescriptor.0") + this.getStatus());
                }
            }
        }
        finally {
            this._listenerLock.unlock();
        }
        String msg = null;
        if (DEBUG_TASK_STATES) {
            msg = this.getName() + " " + field.toString() + "=";
            switch (field) {
                case STATUS: {
                    msg = msg + this.getStatus();
                    break;
                }
                case MESSAGE: {
                    msg = msg + this.getMessage();
                    break;
                }
                case PROGRESS: {
                    msg = msg + this.getProgress();
                    break;
                }
            }
            System.err.println(msg + " >listeners notified");
        }
    }

    private boolean tryListenerLocked() {
        try {
            return this._listenerLock.tryLock(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    private void unlockListener() {
        if (this._listenerLock.isHeldByCurrentThread()) {
            this._listenerLock.unlock();
        }
    }

    public boolean isCancelled() {
        if (this.m_isCancelled) {
            return true;
        }
        if (this._throwable instanceof ExecutionException) {
            return ((ExecutionException)this._throwable).getCause() instanceof CancellationException;
        }
        return this._throwable instanceof CancellationException;
    }

    public void setCancelled(boolean isCancelled) {
        this.m_isCancelled = isCancelled;
    }

    public long getElapsedTime() {
        if (this._elapseTime != -1L) {
            return this._elapseTime;
        }
        return this._lastProgressTime - this._startTime;
    }

    public long getStartTime() {
        return this._startTime;
    }

    public long getLastProgressTime() {
        return this._lastProgressTime;
    }

    public Icon getIcon() {
        if (this.getStatus() == null) {
            return null;
        }
        if (this.getStatus() == IRaptorTaskStatus.FAILED) {
            return IImageRegistry.LIGHT_RED;
        }
        if (this.getStatus() == IRaptorTaskStatus.RUNNABLE) {
            return IImageRegistry.LIGHT_GREEN;
        }
        if (this.getStatus() == IRaptorTaskStatus.NEW || this.getStatus() == IRaptorTaskStatus.PAUSED) {
            return IImageRegistry.LIGHT_YELLOW;
        }
        if (this.getStatus() == IRaptorTaskStatus.FINISHED && !this.isCancelled()) {
            return IImageRegistry.LIGHT_GREEN;
        }
        return IImageRegistry.LIGHT_RED;
    }

    public String getMessage() {
        return this._message;
    }

    public String getName() {
        return this._name;
    }

    public int getProgress() {
        return this._progress;
    }

    public IRaptorTaskStatus getStatus() {
        return this._status;
    }

    public Throwable getThrowable() {
        return this._throwable;
    }

    public void makeProgress(int units) {
        int oldVal = this._progress;
        this._progress += units;
        this.notifyListener(PROPERTY.PROGRESS, oldVal);
    }

    public void makeProgress(int units, boolean useListenerLock) {
        if (useListenerLock) {
            try {
                if (this.tryListenerLocked()) {
                    this.makeProgress(units);
                }
                this._progress += units;
            }
            finally {
                this.unlockListener();
            }
        } else {
            this.makeProgress(units);
            return;
        }
    }

    public void setMessage(String message) {
        String oldMsg = this._message;
        this._message = message;
        this.notifyListener(PROPERTY.MESSAGE, oldMsg);
    }

    public void setProgress(int units) {
        int oldVal = this._progress;
        this._progress = units;
        this.notifyListener(PROPERTY.PROGRESS, oldVal);
    }

    void setStatus(IRaptorTaskStatus status) {
        this.setStatus(status, null);
    }

    void setStatus(IRaptorTaskStatus status, Throwable th) {
        IRaptorTaskStatus oldStatus = this._status;
        if (this._startTime == 0L && status == IRaptorTaskStatus.RUNNABLE) {
            this._lastProgressTime = this._startTime = System.currentTimeMillis();
        }
        this._status = status;
        this._throwable = th;
        if (oldStatus != status || status == IRaptorTaskStatus.NEW) {
            this.notifyListener(PROPERTY.STATUS, (Object)oldStatus);
        }
    }

    public boolean isInDeterminate() {
        return this._isInDeterminate;
    }

    public IRaptorTaskRunMode getRunMode() {
        return this._runMode;
    }

    public void overrideElapseTime(long elapseTime) {
        this._elapseTime = elapseTime;
    }

    public static enum PROPERTY {
        NAME,
        MESSAGE,
        PROGRESS,
        STATUS;

    }
}

