/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import oracle.dbtools.parser.plsql.doc.DocURL;
import oracle.dbtools.parser.plsql.doc.Substr;

public class BasicSuggestedItem
implements Comparable {
    private String _owner;
    private String _name;
    private int _len = 0;
    public String _type;
    private int _pos = -1;
    public String columnType;
    public DocURL doc = null;

    public BasicSuggestedItem(BasicSuggestedItem src, int len) {
        if (len <= src.getName().length() && !src.getName().startsWith("...")) {
            this.setPrefixLength(len);
        } else {
            this.setPrefixLength(0);
        }
        this.setName(src.getName());
        this.setType(src.getType());
        this.setOwner(src.getOwner());
        this.setDoc(src.getDoc());
    }

    public BasicSuggestedItem(String type, String owner, String name) {
        this(type, owner, name, -1);
    }

    public BasicSuggestedItem(String type, String owner, String name, int pos) {
        this._name = name;
        this._type = type;
        this._owner = owner;
        this._pos = pos;
    }

    private int priority() {
        if ("ARGUMENT".equalsIgnoreCase(this._type)) {
            return -2;
        }
        if ("EQUIJOIN CONDITION".equalsIgnoreCase(this._type)) {
            return -1;
        }
        if ("COLUMN".equalsIgnoreCase(this._type)) {
            return 0;
        }
        if ("TABLE".equalsIgnoreCase(this._type)) {
            return 1;
        }
        if ("VIEW".equalsIgnoreCase(this._type)) {
            return 2;
        }
        if ("KEYWORD".equalsIgnoreCase(this._type)) {
            return 3;
        }
        if ("HISTORY".equalsIgnoreCase(this._type)) {
            return 4;
        }
        if ("SNIPPET".equalsIgnoreCase(this._type)) {
            return 5;
        }
        if ("TEMPLATE".equalsIgnoreCase(this._type)) {
            return 6;
        }
        if (this._type.indexOf("CHAR") >= 0) {
            return 7;
        }
        if ("STRING".equals(this._type)) {
            return 7;
        }
        if ("INTEGER".equals(this._type) || "NUMBER".equals(this._type)) {
            return 7;
        }
        if ("DATE".equals(this._type) || "TIMESTAMP".equals(this._type)) {
            return 7;
        }
        if ("BOOLEAN".equals(this._type)) {
            return 7;
        }
        if ("USER DEFINED".equals(this._type) || "TYPE".equals(this._type) || "SUBTYPE".equals(this._type)) {
            return 7;
        }
        if ("SCHEMA".equals(this._type)) {
            return 8;
        }
        if ("PACKAGE".equalsIgnoreCase(this._type)) {
            return 9;
        }
        if ("FUNCTION".equalsIgnoreCase(this._type)) {
            return 10;
        }
        if ("PROCEDURE".equalsIgnoreCase(this._type)) {
            return 10;
        }
        if ("SEQUENCE".equalsIgnoreCase(this._type)) {
            return 11;
        }
        return 9999;
    }

    public String getName() {
        return this._name;
    }

    protected void setName(String name) {
        this._name = name;
    }

    public String getOwner() {
        return this._owner;
    }

    protected void setOwner(String owner) {
        this._owner = owner;
    }

    public String getType() {
        return this._type;
    }

    protected void setType(String type) {
        this._type = type;
    }

    protected int getPos() {
        return this._pos;
    }

    protected void setPos(int pos) {
        this._pos = pos;
    }

    protected String getcolumnType() {
        return this.columnType;
    }

    protected void setcolumnType(String ctype) {
        this.columnType = ctype;
    }

    protected DocURL getDoc() {
        return this.doc;
    }

    protected void setDoc(DocURL doc) {
    }

    public int getPrefixLength() {
        return this._len;
    }

    public void setPrefixLength(int len) {
        this._len = len;
    }

    public String toString() {
        if ("SCHEMA".equals(this._type)) {
            return this._name;
        }
        if (this._owner != null && 0 < this._owner.length()) {
            return this._owner + "." + this._name;
        }
        return this._name;
    }

    public boolean isDocSnippet() {
        return "SNIPPET".equals(this.getType()) && !"...".equals(this.getName()) && !"select * from".equalsIgnoreCase(this.getName());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BasicSuggestedItem)) {
            return false;
        }
        return this.compareTo(obj) == 0;
    }

    public int compareTo(Object obj) {
        BasicSuggestedItem src = (BasicSuggestedItem)obj;
        if (this._pos != -1 && this._pos != src._pos) {
            return this._pos - src._pos;
        }
        if (this.priority() != src.priority()) {
            return this.priority() - src.priority();
        }
        if (this._name == null) {
            return -1;
        }
        if (src._name == null) {
            return 1;
        }
        if (this._name.startsWith("...") && !src._name.startsWith("...")) {
            return 1;
        }
        if (!this._name.startsWith("...") && src._name.startsWith("...")) {
            return -1;
        }
        if (this._owner == null && src._owner != null) {
            return -1;
        }
        if (src._owner == null && this._owner != null) {
            return 1;
        }
        if (this._owner != null && !this._owner.equals(src._owner)) {
            return this._owner.compareTo(src._owner);
        }
        if ("EQUIJOIN CONDITION".equalsIgnoreCase(this._type)) {
            String NAME = this._name.toUpperCase();
            String srcNAME = src._name.toUpperCase();
            if (NAME.endsWith("_ID") && !srcNAME.endsWith("_ID") || NAME.endsWith("_NAME") && !srcNAME.endsWith("_NAME")) {
                return -1;
            }
            if (!NAME.endsWith("_ID") && srcNAME.endsWith("_ID") || !NAME.endsWith("_NAME") && srcNAME.endsWith("_NAME")) {
                return 1;
            }
        } else if ("SNIPPET".equalsIgnoreCase(this._type)) {
            return this._name.length() - src._name.length();
        }
        String name1 = this.getName();
        String name2 = src.getName();
        return BasicSuggestedItem.compareInsensitive(name1, name2);
    }

    public static List<BasicSuggestedItem> addBasicSuggestions(Set<Substr> topSuggestions, String type) {
        LinkedList<BasicSuggestedItem> list = new LinkedList<BasicSuggestedItem>();
        for (Substr ts : topSuggestions) {
            String s = ts.cutSrc();
            s = s.replace("<", "&lt;");
            s = s.replace(">", "&gt;");
            BasicSuggestedItem si = new BasicSuggestedItem(type, null, s);
            si.doc = ts.getDoc();
            list.add(si);
        }
        return list;
    }

    public static int countBasicOwners(Set<BasicSuggestedItem> dbColumns) {
        HashSet<String> owners = new HashSet<String>();
        for (BasicSuggestedItem si : dbColumns) {
            owners.add(si.getOwner());
        }
        return owners.size();
    }

    public static int compareInsensitive(String name1, String name2) {
        int result = name1.compareToIgnoreCase(name2);
        if (result == 0) {
            result = name1.compareTo(name2);
        }
        return result;
    }

    public static int compareSensitive(String name1, String name2) {
        return name1.compareTo(name2);
    }
}

