/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.features;

import oracle.dbtools.lsp.features.Range;
import oracle.dbtools.parser.json.Jsonable;
import oracle.dbtools.parser.json.Util;

public class Diagnostics
implements Jsonable {
    Range range;
    Integer severity = null;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    String message;
    String data;

    public Diagnostics(Range range, String message) {
        this.range = range;
        this.message = message;
        this.severity = 1;
    }

    public Diagnostics(Range range, String message, Integer severity) {
        this.range = range;
        this.message = message;
        this.severity = severity;
    }

    public Diagnostics(Range range, String message, Integer severity, String data) {
        this.range = range;
        this.message = message;
        this.severity = severity;
        this.data = data;
    }

    @Override
    public String toJson() {
        return "{ \"range\": " + this.range.toJson() + ", \"message\": \"" + Util.sugarcoatText(this.message) + "\"" + (String)(this.severity == null ? "" : ", \"severity\": " + this.severity) + (String)(this.data == null ? "" : ", \"data\": \"" + this.data + "\"") + " }";
    }

    public int hashCode() {
        return this.toJson().hashCode();
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public String toString() {
        return this.toJson();
    }
}

