/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.TableRenderer;
import oracle.dbtools.raptor.utils.DataTypesUtil;

class HtmlRenderer
extends TableRenderer {
    static final String prolog = "<!DOCTYPE html>\n<html>\n\n<head>\n  <meta charset='Cp1252'>\n  \n  <title>Result Data</title>\n  \n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n\n  \n  <style>\n  * { \n    margin: 0; \n    padding: 0; \n  }\n  body { \n    font: 14px/1.4 Palatino, Serif; \n  }\n  \n  /* \n  Generic Styling, for Desktops/Laptops \n  */\n  table { \n    width: 100%; \n    border-collapse: collapse; \n  }\n  /* Zebra striping */\n  tr:nth-of-type(odd) { \n    background: #eee; \n  }\n  th { \n    background: #333; \n    color: white; \n    font-weight: bold; \n  }\n  td, th { \n    padding: 6px; \n    border: 1px solid #9B9B9B; \n    text-align: left; \n  }\n  @media \n  only screen and (max-width: 760px),\n  (min-device-width: 768px) and (max-device-width: 1024px)  {\n    table, thead, tbody, th, td, tr { display: block; }\n    thead tr { position: absolute;top: -9999px;left: -9999px;}\n    tr { border: 1px solid #9B9B9B; }\n    td { border: none;border-bottom: 1px solid #9B9B9B; position: relative;padding-left: 50%; }\n    \n    td:before { position: absolute;top: 6px;left: 6px;width: 45%; padding-right: 10px; white-space: nowrap;}\n    \n    /*\n    Label the data\n    */\ntd:nth-of-type(0):before { content: \"COUNTRY_ID\"; }\ntd:nth-of-type(1):before { content: \"COUNTRY_NAME\"; }\ntd:nth-of-type(2):before { content: \"REGION_ID\"; }\n  }\n  \n  /* Smartphones (portrait and landscape) ----------- */\n  @media only screen\n  and (min-device-width : 320px)\n  and (max-device-width : 480px) {\n    body { \n      padding: 0; \n      margin: 0; \n      width: 320px; }\n    }\n  \n  /* iPads (portrait and landscape) ----------- */\n  @media only screen and (min-device-width: 768px) and (max-device-width: 1024px) {\n    body { \n      width: 495px; \n    }\n  }\n  \n  </style>\n  <!--<![endif]-->\n<script type=\"text/javascript\">\n\nfunction search(){\n  \n  var s = document.getElementById('search').value;\n\n  rows = document.getElementById('data').getElementsByTagName('TR');\n  for(var i=0;i<rows.length;i++){\n    if ( rows[i].textContent.indexOf(s)>0  || s.length==0 ) {\n\t  rows[i].style.display ='';\n    } else {\n      rows[i].style.display ='none';\n    }\n  }\n}\n\n\nvar timer;\nfunction delayedSearch() {\n\tclearTimeout(timer);\n\tconsole.log('delay-ing')\n    timer = setTimeout(function () {\n\t\tconsole.log('delay-running')\n\t\tsearch();\n    }, 500);\n  }</script>\n</head>\n\n<body>\n<div><input type=\"text\" size=\"30\" maxlength=\"1000\" value=\"\" id=\"search\" onkeyup=\"delayedSearch();\" /><input type=\"button\" value=\"Go\" onclick=\"lsearch();\"/> </div>\n<table><thead><tr>";

    public HtmlRenderer(BackgroundParser parser) {
        super(parser);
    }

    @Override
    public String render(ResultSet rs, Connection conn) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        StringBuilder ret = new StringBuilder(prolog);
        int cols = rsmd.getColumnCount();
        String[] columnNames = new String[cols];
        for (int i = 1; i <= cols; ++i) {
            columnNames[i - 1] = rsmd.getColumnName(i);
        }
        boolean isEvenCol = true;
        for (int i = 0; i < columnNames.length; ++i) {
            ret.append("<th>");
            ret.append(columnNames[i]);
            ret.append("</th>\n");
            isEvenCol = !isEvenCol;
        }
        ret.append("</tr></thead>\r\n<tbody id=\"data\">\r\n\n");
        int line = 0;
        while (rs.next() && line++ < 10000) {
            this.jsCallback(rs, conn, line);
            if (this.isSilent) continue;
            ret.append("<tr>\n");
            for (int col = 0; col < columnNames.length; ++col) {
                Object o = rs.getObject(col + 1);
                String s = DataTypesUtil.stringValueChecked(o, conn);
                ret.append("<td>");
                ret.append(s);
                ret.append("</td>");
            }
            ret.append("</tr>\n");
        }
        if (this.isSilent) {
            ret.append("... (silent mode)\n");
        }
        ret.append("</tbody></table><!-- SQL:\nselect * from ...--></body></html>");
        return ret.toString();
    }
}

