/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp;

import java.io.IOException;
import java.util.List;
import oracle.dbtools.app.Completer;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.dictionary.ArboriCatalog;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;

class BackgroundArboriParser
extends BackgroundParser {
    public BackgroundArboriParser(String input, String url, LanguageServer languageServer) throws IOException {
        super(input, Program.getArboriParser(), "program", url, languageServer);
        this.initRegistry(new ArboriCatalog(this));
        this.lateInit();
    }

    @Override
    public void lex() {
        this.allSrc = LexerToken.parse(this.text, true, 57);
        this.src = LexerToken.parse(this.text, false, 57);
    }

    @Override
    public String label(ParseNode node) {
        String label = ((LexerToken)this.src.get((int)node.from)).content;
        if (node.contains("statement")) {
            return label;
        }
        return null;
    }

    @Override
    public String semanticActionsFile() {
        return "arboriCodeLens.arbori";
    }

    @Override
    public boolean isAlive(String connStr) {
        List<LexerToken> src = LexerToken.parse(connStr);
        try {
            String filename = src.get((int)1).content;
            Object connection = this.languageServer.getConnection(filename);
            return connection != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Completer getCompleter() {
        return null;
    }
}

